/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.display.MouseClickTypeHandler;
import org.seamcat.presentation.display.ScatterGroupResultType;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.presentation.simulationview.results.CollectorTableModel;
import org.seamcat.tabulardataio.FileDataIO;

public class ScatterGroupDialog
extends EscapeDialog {
    public ScatterGroupDialog(ScatterGroupResultType values) {
        super((Frame)MainWindow.getInstance(), true);
        this.setTitle(values.getName());
        ArrayList<Object> objs = new ArrayList<Object>();
        objs.addAll(values.getValues());
        final JTable table = new JTable(new CollectorTableModel(values.getName(), objs));
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseClickTypeHandler(table));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)table.getTableHeader(), "North");
        jPanel.add((Component)table, "Center");
        this.getContentPane().add((Component)new ScrollingBorderPanel(jPanel, ""), "Center");
        ControlButtonPanel control = new ControlButtonPanel(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDataIO fileIO;
                ScatterDiagramResultType selected = (ScatterDiagramResultType)table.getModel().getValueAt(table.getSelectedRow(), 0);
                if (selected != null && (fileIO = SaveFileChooser.chooseFile(ScatterGroupDialog.this.getParent())) != null) {
                    fileIO.saveValues(selected);
                }
            }
        }, null);
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(200, right.getPreferredSize().height));
        right.add(control);
        this.getContentPane().add((Component)right, "East");
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

