/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.tabulardataio.FileDataIO;

public class ScatterDiagramDialog
extends EscapeDialog {
    public ScatterDiagramDialog(final ScatterDiagramResultType scatter) {
        super((Frame)MainWindow.getInstance(), true);
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)scatter.def().name()));
        Iterator iterator = scatter.value().iterator();
        while (iterator.hasNext()) {
            Point2D point2D = (Point2D)iterator.next();
            series.add(point2D.getX(), point2D.getY());
        }
        collection.addSeries(series);
        JFreeChart scatterPlot = ChartFactory.createScatterPlot(scatter.def().name(), scatter.def().unit(), scatter.def().yUnit(), collection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot p = scatterPlot.getXYPlot();
        scatterPlot.setBackgroundPaint(this.getBackground());
        p.setBackgroundPaint(Color.white);
        p.setDomainGridlinePaint(Color.black);
        p.setRangeGridlinePaint(Color.black);
        final ChartPanel chartPanel = new ChartPanel(scatterPlot);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.getContentPane().add((Component)chartPanel, "Center");
        this.setTitle(scatter.def().name());
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(200, right.getPreferredSize().height));
        right.add(new ControlButtonPanel(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(ScatterDiagramDialog.this.getParent());
                if (fileIO != null) {
                    fileIO.saveValues(scatter);
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSaver.saveChart(chartPanel);
            }
        }));
        this.getContentPane().add((Component)right, "East");
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 475));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

