/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Collections;
import javax.swing.JDialog;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;
import org.seamcat.presentation.components.UnwantedEmissionGraph2;
import org.seamcat.presentation.display.FunctionPanel;

public class FunctionDialog
extends EscapeDialog {
    public FunctionDialog(FunctionResultType function) {
        super((Frame)MainWindow.getInstance(), true);
        this.setTitle(function.def().name());
        if (function.value() instanceof MaskFunctionImpl) {
            DiscreteFunction2TableModelAdapter dataset = new DiscreteFunction2TableModelAdapter();
            UnwantedEmissionGraph2 graph = new UnwantedEmissionGraph2(dataset);
            graph.setLabels(function.def().unit(), function.def().yUnit());
            graph.setVictimCharacteristics(-1.0, -1.0, false);
            dataset.setDiscreteFunction2((MaskFunctionImpl)function.value());
            this.getContentPane().add((Component)graph, "Center");
        } else {
            FunctionPanel panel = new FunctionPanel(this);
            panel.setModel(Collections.singletonList(function));
            this.getContentPane().add((Component)panel, "Center");
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 475));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

