/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.BarChartDisplaySelector;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.tabulardataio.FileDataIO;

public class BarChartDialog
extends EscapeDialog {
    private final DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
    private ChartPanel barChart;
    private List<BarChartValue> chartPoints;
    private String title;

    public BarChartDialog(final BarChartResultType barChart) {
        super((Frame)MainWindow.getInstance(), true);
        JFreeChart chart = ChartFactory.createBarChart(barChart.def().name(), barChart.def().unit(), barChart.def().yUnit(), this.categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryAxis domainAxis = chart.getCategoryPlot().getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        this.barChart = new ChartPanel(chart);
        this.barChart.setMouseZoomable(true, false);
        this.barChart.getChart().setBackgroundPaint(this.getBackground());
        CategoryPlot p = this.barChart.getChart().getCategoryPlot();
        p.setBackgroundPaint(Color.white);
        p.getDomainAxis().setTickLabelPaint(this.barChart.getForeground());
        p.getDomainAxis().setLabelPaint(this.barChart.getForeground());
        p.getRangeAxis().setTickLabelPaint(this.barChart.getForeground());
        p.getRangeAxis().setLabelPaint(this.barChart.getForeground());
        this.chartPoints = barChart.value();
        this.title = barChart.def().name();
        this.plotChart(true);
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.barChart, "Center");
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(250, right.getPreferredSize().height));
        BarChartDisplaySelector selector = new BarChartDisplaySelector();
        selector.getSum().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartDialog.this.plotChart(true);
            }
        });
        selector.getAvg().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarChartDialog.this.plotChart(false);
            }
        });
        right.add(selector);
        right.add(new ControlButtonPanel(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(BarChartDialog.this.getParent());
                if (fileIO != null) {
                    fileIO.saveValues(barChart);
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSaver.saveChart(BarChartDialog.this.barChart);
            }
        }));
        this.getContentPane().add((Component)right, "East");
        this.setTitle(barChart.def().name());
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    private void plotChart(boolean sum) {
        this.categoryDataset.clear();
        LinkedHashMap<String, Double> sums = new LinkedHashMap<String, Double>();
        for (BarChartValue barChartValue : this.chartPoints) {
            void var5_12;
            Double d = (Double)sums.get(barChartValue.getName());
            if (d == null) {
                Double d2 = 0.0;
            }
            Double d3 = var5_12.doubleValue() + barChartValue.getValue();
            sums.put(barChartValue.getName(), d3);
        }
        if (sum) {
            for (Map.Entry entry : sums.entrySet()) {
                this.categoryDataset.addValue((Number)entry.getValue(), (Comparable)((Object)this.title), (Comparable)entry.getKey());
            }
        } else {
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (BarChartValue barChartValue : this.chartPoints) {
                Integer c = (Integer)count.get(barChartValue.getName());
                if (c == null) {
                    c = 0;
                }
                Integer n = c;
                Integer n2 = c = Integer.valueOf(c + 1);
                count.put(barChartValue.getName(), c);
            }
            for (Map.Entry entry : sums.entrySet()) {
                this.categoryDataset.addValue((Double)entry.getValue() / (double)((Integer)count.get(entry.getKey())).intValue(), (Comparable)((Object)this.title), (Comparable)entry.getKey());
            }
        }
    }
}

