/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.FunctionType;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.AntennaPatterns;
import org.seamcat.presentation.DialogTableToDataSet;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapterInterface;
import org.seamcat.presentation.components.FunctionButtonPanel;
import org.seamcat.presentation.components.SeamcatTable;

public class UserDefinedFunctionPanel
extends JPanel {
    private JTable dataTable;
    private DiscreteFunctionGraph functionGraph;
    private double symmetryPoint = 0.0;
    private boolean usePropabilitySymmetrizeFunction = false;
    private String x;
    private String y;
    TableRowSorter<TableModel> sorter;

    public UserDefinedFunctionPanel(String borderTitle, String x, String y) {
        super(new GridBagLayout());
        this.x = x;
        this.y = y;
        this.functionGraph = new DiscreteFunctionGraph(new DiscreteFunctionTableModelAdapter(), x, y);
        this.dataTable = new SeamcatTable(this.functionGraph.getDataSet());
        JTableHeader header = this.dataTable.getTableHeader();
        header.setUpdateTableInRealTime(true);
        this.sorter = new MyTableRowSorter(this.functionGraph.getDataSet());
        this.dataTable.setRowSorter(this.sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        JScrollPane dataTableScrollPane = new JScrollPane(this.dataTable);
        Dimension paneDims = new Dimension(150, 350);
        dataTableScrollPane.setMinimumSize(paneDims);
        dataTableScrollPane.setPreferredSize(paneDims);
        dataTableScrollPane.setMaximumSize(paneDims);
        GridBagConstraints constr = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)dataTableScrollPane, constr);
        this.add((Component)new DialogFunctionButtonPanel(this.functionGraph.getDataSet()), constr);
        constr.fill = 1;
        constr.weightx = 50.0;
        constr.weighty = 50.0;
        this.add((Component)this.functionGraph, constr);
        this.setBorder(new TitledBorder(borderTitle));
    }

    public UserDefinedFunctionPanel(Function function, FunctionType functionType, String x, String y) {
        super(new GridBagLayout());
        boolean polarPlot;
        boolean bl = polarPlot = !functionType.isNone();
        if (polarPlot) {
            AntennaPatterns type = AntennaPatterns.HORIZONTAL;
            if (functionType.isHorizontal()) {
                type = AntennaPatterns.HORIZONTAL;
            } else if (functionType.isVertical()) {
                type = AntennaPatterns.VERTICAL;
            } else if (functionType.isSpherical()) {
                type = AntennaPatterns.SPHERICAL;
            }
            this.functionGraph = new DiscreteFunctionGraph(new DiscreteFunctionTableModelAdapter(), type, x, y);
        } else {
            this.functionGraph = new DiscreteFunctionGraph(new DiscreteFunctionTableModelAdapter(), x, y);
        }
        this.dataTable = new SeamcatTable(this.functionGraph.getDataSet());
        JTableHeader header = this.dataTable.getTableHeader();
        header.setUpdateTableInRealTime(true);
        this.sorter = new MyTableRowSorter(this.functionGraph.getDataSet());
        this.dataTable.setRowSorter(this.sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        JScrollPane dataTableScrollPane = new JScrollPane(this.dataTable);
        Dimension paneDims = new Dimension(150, 350);
        dataTableScrollPane.setMinimumSize(paneDims);
        dataTableScrollPane.setPreferredSize(paneDims);
        dataTableScrollPane.setMaximumSize(paneDims);
        GridBagConstraints constr = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)dataTableScrollPane, constr);
        this.add((Component)new DialogFunctionButtonPanel(this.functionGraph.getDataSet()), constr);
        constr.fill = 1;
        constr.weightx = 50.0;
        constr.weighty = 50.0;
        this.add((Component)this.functionGraph, constr);
        this.setBorder(new TitledBorder(functionType.getTitle()));
        this.setDiscreteFunction((DiscreteFunction)function);
    }

    public void clear() {
        this.setDiscreteFunction(new DiscreteFunction());
    }

    public DiscreteFunction getDiscreteFunction() {
        return this.functionGraph.getDataSet().getFunction();
    }

    public TableModel getModel() {
        return this.functionGraph.getDataSet();
    }

    public void stopEditing() {
        if (this.dataTable.isEditing()) {
            this.dataTable.getCellEditor().stopCellEditing();
        }
    }

    public void setDiscreteFunction(DiscreteFunction d) {
        this.functionGraph.getDataSet().setDiscreteFunction(d);
    }

    public void setUsePropabilitySymmetrizeFunction(boolean usePropabilitySymmetrizeFunction) {
        this.usePropabilitySymmetrizeFunction = usePropabilitySymmetrizeFunction;
    }

    private class MyTableRowSorter
    extends TableRowSorter<TableModel> {
        DiscreteFunctionTableModelAdapter model;
        private boolean sort;

        public MyTableRowSorter(DiscreteFunctionTableModelAdapter model) {
            super(model);
            this.sort = true;
            this.model = model;
            this.setSortsOnUpdates(false);
        }

        @Override
        protected void fireSortOrderChanged() {
            if (this.sort) {
                this.model.fireChangeListeners();
            }
        }

        @Override
        public void sort() {
            if (this.sort) {
                super.sort();
                this.onSorted();
            }
            this.sort = true;
        }

        @Override
        public void toggleSortOrder(int column) {
            RowSorter.SortKey key = new RowSorter.SortKey(column, SortOrder.ASCENDING);
            this.setSortKeys(Collections.singletonList(key));
        }

        private void onSorted() {
            ArrayList<Point2D> list = new ArrayList<Point2D>();
            int rowCount = UserDefinedFunctionPanel.this.dataTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                double x = (Double)UserDefinedFunctionPanel.this.dataTable.getValueAt(i, 0);
                double y = (Double)UserDefinedFunctionPanel.this.dataTable.getValueAt(i, 1);
                Point2D point = new Point2D(x, y);
                list.add(point);
            }
            this.sort = false;
            this.model.setPoints(list);
        }
    }

    private class DialogFunctionButtonPanel
    extends FunctionButtonPanel {
        public DialogFunctionButtonPanel(DiscreteFunctionTableModelAdapterInterface model) {
            super(model, UserDefinedFunctionPanel.this.x, UserDefinedFunctionPanel.this.y);
        }

        @Override
        public void saveChartImage() {
            UserDefinedFunctionPanel.this.functionGraph.saveImage();
        }

        @Override
        public void btnDeleteActionPerformed() {
            UserDefinedFunctionPanel.this.functionGraph.getDataSet().deleteRow(UserDefinedFunctionPanel.this.dataTable.getSelectedRow());
        }

        @Override
        public void btnSaveActionPerformed() {
            UserDefinedFunctionPanel.this.stopEditing();
            super.btnSaveActionPerformed();
        }

        @Override
        public void btnSymActionPerformed() {
            UserDefinedFunctionPanel.this.stopEditing();
            this.checkEntries();
            if (UserDefinedFunctionPanel.this.usePropabilitySymmetrizeFunction) {
                DialogTableToDataSet.symmetrizeFunction(UserDefinedFunctionPanel.this.functionGraph.getDataSet().getFunction(), UserDefinedFunctionPanel.this.symmetryPoint);
            } else {
                DialogTableToDataSet.symmetrize(UserDefinedFunctionPanel.this.functionGraph.getDataSet().getFunction().points(), UserDefinedFunctionPanel.this.symmetryPoint);
            }
            UserDefinedFunctionPanel.this.functionGraph.getDataSet().sortPoints();
            UserDefinedFunctionPanel.this.functionGraph.getDataSet().fireChangeListeners();
        }

        private void checkEntries() {
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            DiscreteFunction function = UserDefinedFunctionPanel.this.functionGraph.getDataSet().getFunction();
            points.addAll(function.points());
            boolean hasBeenChanged = false;
            for (int i = 1; i < points.size(); ++i) {
                if (!Mathematics.equals(((Point2D)points.get(i)).getX(), ((Point2D)points.get(i - 1)).getX(), 1.0E-5)) continue;
                points.set(i, new Point2D(((Point2D)points.get(i)).getX() + 1.0E-4, ((Point2D)points.get(i)).getY()));
                hasBeenChanged = true;
            }
            if (hasBeenChanged) {
                UserDefinedFunctionPanel.this.setDiscreteFunction((DiscreteFunction)Factory.functionFactory().discreteFunction(points));
            }
        }
    }
}

