/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.library.LibraryItemWrapper;

public class GenericSelectionDialog<T>
extends EscapeDialog {
    private JList list;
    private boolean clone;

    public GenericSelectionDialog(JFrame parent, String windowTitle, Iterable<T> elements) {
        this(parent, windowTitle, elements, true);
    }

    public GenericSelectionDialog(JFrame parent, String windowTitle, Iterable<T> elements, boolean clone) {
        super((Frame)parent, true);
        this.clone = clone;
        this.setTitle(windowTitle);
        DefaultListModel<LibraryItemWrapper<LibraryItem>> model = new DefaultListModel<LibraryItemWrapper<LibraryItem>>();
        this.list = new JList(model);
        for (T element : elements) {
            if (element instanceof LibraryItem) {
                model.addElement(new LibraryItemWrapper<LibraryItem>(model.getSize(), (LibraryItem)element));
                continue;
            }
            model.addElement((LibraryItemWrapper<LibraryItem>)element);
        }
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.list);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.setSize(new Dimension(450, 450));
        this.setLocationRelativeTo(parent);
        this.list.setSelectedIndex(0);
    }

    public T getSelectedValue() {
        Object value = this.list.getSelectedValue();
        if (!this.clone) {
            if (value instanceof LibraryItemWrapper) {
                return ((LibraryItemWrapper)value).getItem();
            }
            return (T)value;
        }
        if (value instanceof Configuration) {
            return (T)((Configuration)value).copy();
        }
        if (value instanceof LibraryItemWrapper) {
            Object item = ((LibraryItemWrapper)value).getItem();
            if (item instanceof ReceiverModel) {
                return (T)ProxyHelper.deepCloneComposite(ReceiverModel.class, (ReceiverModel)item);
            }
            if (item instanceof TransmitterModel) {
                return (T)ProxyHelper.deepCloneComposite(TransmitterModel.class, (TransmitterModel)item);
            }
            if (item instanceof Configuration) {
                return (T)((Configuration)item).copy();
            }
        }
        throw new RuntimeException("cant clone: " + value);
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }
}

