/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.jfree.ui.FilesystemFilter;
import org.seamcat.presentation.SeamcatJFileChooser;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapterInterface;
import org.seamcat.tabulardataio.FileDataIO;

public abstract class FunctionButtonPanel
extends JPanel {
    protected static final ResourceBundle stringlist = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private FilesystemFilter xlsFilter;
    private FilesystemFilter xlsxFilter;
    private FilesystemFilter txtFilter;
    protected JFileChooser fileChooser = new SeamcatJFileChooser();
    protected FileDataIO fileio = new FileDataIO();
    private DiscreteFunctionTableModelAdapterInterface model;
    private String[] units;

    public FunctionButtonPanel(DiscreteFunctionTableModelAdapterInterface model, String ... units) {
        this.model = model;
        this.units = units;
        this.xlsFilter = new FilesystemFilter("xls", "Excel files (*.xls)", true);
        this.xlsxFilter = new FilesystemFilter("xlsx", "Excel files (*.xlsx)", true);
        this.txtFilter = new FilesystemFilter("txt", "Text files (*.txt)", true);
        FileFilter first = this.fileChooser.getFileFilter();
        this.fileChooser.setFileFilter(this.txtFilter);
        this.fileChooser.setFileFilter(this.xlsFilter);
        this.fileChooser.setFileFilter(this.xlsxFilter);
        this.fileChooser.setFileFilter(first);
        JButton btnLoad = new JButton(stringlist.getString("BTN_CAPTION_LOAD"));
        JButton btnSave = new JButton(stringlist.getString("BTN_CAPTION_SAVE"));
        JButton btnSaveImage = new JButton("Save image");
        JButton btnClear = new JButton(stringlist.getString("BTN_CAPTION_CLEAR"));
        JButton btnAdd = new JButton(stringlist.getString("BTN_CAPTION_ADD"));
        JButton btnDelete = new JButton(stringlist.getString("BTN_CAPTION_DELETE"));
        JButton btnSym = new JButton(stringlist.getString("BTN_CAPTION_SYM"));
        btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnLoadActionPerformed();
            }
        });
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnSaveActionPerformed();
            }
        });
        btnSaveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.saveChartImage();
            }
        });
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnClearActionPerformed();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnAddActionPerformed();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnDeleteActionPerformed();
            }
        });
        btnSym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionButtonPanel.this.btnSymActionPerformed();
            }
        });
        JPanel stretchPanel = new JPanel(new GridLayout(7, 1));
        stretchPanel.add(btnLoad);
        stretchPanel.add(btnSave);
        stretchPanel.add(btnSaveImage);
        stretchPanel.add(btnClear);
        stretchPanel.add(btnAdd);
        stretchPanel.add(btnDelete);
        stretchPanel.add(btnSym);
        this.add(stretchPanel);
    }

    public void btnAddActionPerformed() {
        this.model.addRow();
    }

    public void btnClearActionPerformed() {
        this.model.clear();
    }

    public abstract void btnDeleteActionPerformed();

    public abstract void saveChartImage();

    public void btnLoadActionPerformed() {
        if (this.fileChooser.showOpenDialog(this) == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.fileio.setFile(selectedFile);
            this.model.setFunction(this.fileio.loadFunction());
        }
    }

    public void btnSaveActionPerformed() {
        File selectedFile;
        this.fileChooser.setFileFilter(this.xlsxFilter);
        if (this.fileChooser.showSaveDialog(this) == 0 && this.okToSave(selectedFile = this.alignSelectedFile())) {
            this.fileio.setFile(this.fileChooser.getSelectedFile());
            this.fileio.saveFunction(this.model.getFunction(), this.units);
        }
    }

    protected File alignSelectedFile() {
        File selectedFile = this.fileChooser.getSelectedFile();
        if (this.fileChooser.getFileFilter() == this.txtFilter) {
            if (!selectedFile.getName().endsWith(".txt")) {
                this.fileChooser.setSelectedFile(new File(selectedFile.getAbsolutePath() + ".txt"));
            }
        } else if (this.fileChooser.getFileFilter() == this.xlsFilter) {
            if (!selectedFile.getName().endsWith(".xls")) {
                this.fileChooser.setSelectedFile(new File(selectedFile.getAbsolutePath() + ".xls"));
            }
        } else if (this.fileChooser.getFileFilter() == this.xlsxFilter && !selectedFile.getName().endsWith(".xlsx")) {
            this.fileChooser.setSelectedFile(new File(selectedFile.getAbsolutePath() + ".xlsx"));
        }
        return this.fileChooser.getSelectedFile();
    }

    protected boolean okToSave(File selectedFile) {
        if (selectedFile.exists()) {
            int res = JOptionPane.showConfirmDialog(this, "<html>The file named <b>" + selectedFile.getName() + "</b> already exists.\nDo you wish to override?", "File already exists", 1);
            if (res == 1) {
                return false;
            }
            if (res == 2) {
                return false;
            }
        }
        return true;
    }

    public abstract void btnSymActionPerformed();
}

