/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatter;
import org.seamcat.presentation.components.ValidatorDocument;

public class DoubleCellEditor2
extends DefaultCellEditor {
    public DoubleCellEditor2() {
        super(new JTextField());
        final JTextField textField = (JTextField)this.editorComponent;
        textField.removeActionListener(this.delegate);
        final DoubleFormatter formatter = new DoubleFormatter();
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return formatter.stringToValue(textField.getText());
            }

            @Override
            public void setValue(Object value) {
                textField.setText(value != null ? value.toString() : "");
            }
        };
        textField.setDocument(new ValidatorDocument(ValidatorDocument.Type.INTEGERS, ValidatorDocument.Type.FLOAT_DELIMITERS, ValidatorDocument.Type.NEGATE));
        textField.addActionListener(this.delegate);
    }

    static class DoubleFormatter
    extends DefaultFormatter {
        DoubleFormatter() {
        }

        @Override
        public Object stringToValue(String string) {
            Double n;
            try {
                n = new Double(string.replace(',', '.'));
            }
            catch (NumberFormatException e) {
                n = null;
            }
            return n;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            return value != null ? ((Number)value).toString() : null;
        }
    }
}

