/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.seamcat.presentation.AntennaPatterns;
import org.seamcat.presentation.components.DiscreteFunctionPlot;
import org.seamcat.presentation.components.DiscreteFunctionPolarPlot;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.components.DiscreteFunctionXYPlot;

public class DiscreteFunctionGraph
extends JPanel {
    public DiscreteFunctionGraph(DiscreteFunctionTableModelAdapter hor, DiscreteFunctionTableModelAdapter ver, DiscreteFunctionTableModelAdapter sph) {
        super(new BorderLayout());
        JTabbedPane pane = new JTabbedPane(3);
        pane.addTab("Horizontal", new DiscreteFunctionXYPlot(hor, "Degree", "Gain (dBi)"));
        pane.addTab("Horizontal (polar)", new DiscreteFunctionPolarPlot(hor, AntennaPatterns.HORIZONTAL));
        pane.addTab("Vertical", new DiscreteFunctionXYPlot(ver, "Degree", "Gain (dBi)"));
        pane.addTab("Vertical (polar)", new DiscreteFunctionPolarPlot(ver, AntennaPatterns.VERTICAL));
        pane.addTab("Spherical", new DiscreteFunctionXYPlot(sph, "Degree", "Gain (dBi)"));
        pane.addTab("Spherical (polar)", new DiscreteFunctionPolarPlot(sph, AntennaPatterns.SPHERICAL));
        this.add((Component)pane, "Center");
    }

    public DiscreteFunctionGraph(DiscreteFunctionTableModelAdapter dataset, AntennaPatterns type, String xCaption, String yCaption) {
        super(new BorderLayout());
        JTabbedPane pane = new JTabbedPane(3);
        pane.addTab("X & Y", new DiscreteFunctionXYPlot(dataset, xCaption, yCaption));
        pane.addTab("Polar", new DiscreteFunctionPolarPlot(dataset, type));
        this.add((Component)pane, "Center");
    }

    public DiscreteFunctionGraph(DiscreteFunctionTableModelAdapter dataset, String xCaption, String yCaption) {
        super(new BorderLayout());
        this.add((Component)new DiscreteFunctionXYPlot(dataset, xCaption, yCaption), "Center");
    }

    public DiscreteFunctionTableModelAdapter getDataSet() {
        return this.getSelectedComponent().getDataSet();
    }

    public static void applyStyles(ChartPanel chartPanel, Font font, boolean legend) {
        JFreeChart xyChart = chartPanel.getChart();
        if (!legend) {
            xyChart.removeLegend();
        }
        xyChart.setBackgroundPaint(chartPanel.getBackground());
        XYPlot p = chartPanel.getChart().getXYPlot();
        p.setBackgroundPaint(Color.WHITE);
        p.setRangeGridlinePaint(chartPanel.getForeground());
        p.setDomainGridlinePaint(chartPanel.getForeground());
        p.getDomainAxis().setTickLabelFont(font);
        p.getDomainAxis().setTickLabelPaint(chartPanel.getForeground());
        p.getDomainAxis().setLabelFont(font);
        p.getDomainAxis().setLabelPaint(chartPanel.getForeground());
        p.getRangeAxis().setTickLabelFont(font);
        p.getRangeAxis().setTickLabelPaint(chartPanel.getForeground());
        p.getRangeAxis().setLabelFont(font);
        p.getRangeAxis().setLabelPaint(chartPanel.getForeground());
    }

    public void drawGraphToGraphics(Graphics2D g, Rectangle2D r) {
        this.getSelectedComponent().drawGraphToGraphics(g, r);
    }

    public void saveImage() {
        this.getSelectedComponent().saveChartImage();
    }

    private DiscreteFunctionPlot getSelectedComponent() {
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            return (DiscreteFunctionPlot)((JTabbedPane)component).getSelectedComponent();
        }
        return (DiscreteFunctionPlot)component;
    }
}

