/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.DialogTableToDataSet;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.ACLRUI;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapterInterface;
import org.seamcat.presentation.components.FunctionButtonPanel;
import org.seamcat.presentation.components.SeamcatTable;
import org.seamcat.presentation.components.UnwantedEmissionGraph2;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class DiscreteFunction2Panel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DiscreteFunction2Panel.class);
    private JTable dataTable;
    private DiscreteFunction2TableModelAdapter model = new DiscreteFunction2TableModelAdapter();
    private UnwantedEmissionGraph2 userDefinitionPanel = new UnwantedEmissionGraph2(this.model);
    private GenericPanelEditor<ACLRUI> editor;

    public DiscreteFunction2Panel() {
        super(new BorderLayout());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing Panel for 3D Functions");
        }
        this.dataTable = new SeamcatTable(this.model);
        JScrollPane dataTableScrollPane = new JScrollPane(this.dataTable);
        Dimension paneDims = new Dimension(225, 350);
        dataTableScrollPane.setMinimumSize(paneDims);
        dataTableScrollPane.setPreferredSize(paneDims);
        dataTableScrollPane.setMaximumSize(paneDims);
        GridBagConstraints constr = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)dataTableScrollPane, constr);
        centerPanel.add((Component)new DialogFunctionButtonPanel(this.model), constr);
        constr.fill = 1;
        constr.weightx = 50.0;
        constr.weighty = 50.0;
        centerPanel.add((Component)this.userDefinitionPanel, constr);
        this.add((Component)centerPanel, "Center");
    }

    public MaskFunctionImpl getFunctionable() {
        return this.model.getDiscreteFunction2();
    }

    public void setFunctionable(MaskFunctionImpl f, String xUnit, String yUnit) {
        this.model.setDiscreteFunction2(f);
        if (xUnit != null || yUnit != null) {
            this.userDefinitionPanel.setLabels(xUnit, yUnit);
        }
    }

    public void stopEditing() {
        if (this.dataTable.isEditing()) {
            this.dataTable.getCellEditor().stopCellEditing();
        }
    }

    public void setVictimCharacteristics(double victimBandwidth, double frequencyOffset, boolean showACLR, double interfererBandwidth) {
        this.userDefinitionPanel.setVictimCharacteristics(victimBandwidth, frequencyOffset, showACLR);
        if (showACLR && this.editor == null) {
            ACLRUI aclrui = Factory.prototype(ACLRUI.class);
            Factory.when(aclrui.displayACLR()).thenReturn(interfererBandwidth);
            this.editor = new GenericPanelEditor<ACLRUI>(MainWindow.getInstance(), ACLRUI.class, Factory.build(aclrui));
            this.editor.getCalculatedValues().get(0).getEvaluateButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ACLRUI model = (ACLRUI)DiscreteFunction2Panel.this.editor.getModel();
                    if (model.showACLR()) {
                        DiscreteFunction2Panel.this.userDefinitionPanel.setAclrEnabled(true, true);
                        DiscreteFunction2Panel.this.userDefinitionPanel.setInterferingBandwidth(model.displayACLR());
                        DiscreteFunction2Panel.this.userDefinitionPanel.setAdjacentChannel(model.adjacentChannel());
                        DiscreteFunction2Panel.this.userDefinitionPanel.refreshChart();
                    } else {
                        DiscreteFunction2Panel.this.userDefinitionPanel.setAclrEnabled(false, false);
                        DiscreteFunction2Panel.this.userDefinitionPanel.refreshChart();
                    }
                }
            });
            this.add(this.editor, "South");
            this.userDefinitionPanel.setInterferingBandwidth(interfererBandwidth);
        }
    }

    private class DialogFunctionButtonPanel
    extends FunctionButtonPanel {
        public DialogFunctionButtonPanel(DiscreteFunctionTableModelAdapterInterface model) {
            super(model, "Offset (MHz)", "Mask Value (dBc)", "Ref. BW (kHz)");
        }

        @Override
        public void saveChartImage() {
            DiscreteFunction2Panel.this.userDefinitionPanel.saveChartImage();
        }

        @Override
        public void btnDeleteActionPerformed() {
            DiscreteFunction2Panel.this.model.deleteRow(DiscreteFunction2Panel.this.dataTable.getSelectedRow());
        }

        @Override
        public void btnSaveActionPerformed() {
            DiscreteFunction2Panel.this.stopEditing();
            super.btnSaveActionPerformed();
        }

        @Override
        public void btnSymActionPerformed() {
            List<Point2D> pointsList = DiscreteFunction2Panel.this.model.getFunction().points();
            if (pointsList != null) {
                DiscreteFunction2Panel.this.stopEditing();
                this.checkEntries();
                DialogTableToDataSet.symmetrizeFunction(DiscreteFunction2Panel.this.model.getFunction(), 0.0);
                DiscreteFunction2Panel.this.model.sortPoints();
                DiscreteFunction2Panel.this.model.fireChangeListeners();
            }
        }

        private void checkEntries() {
            boolean hasBeenChanged = false;
            ArrayList<Point2D> points2D = new ArrayList<Point2D>();
            points2D.addAll(DiscreteFunction2Panel.this.model.getFunction().points());
            for (int i = 1; i < points2D.size(); ++i) {
                if (!Mathematics.equals(((Point2D)points2D.get(i)).getX(), ((Point2D)points2D.get(i - 1)).getX(), 1.0E-5)) continue;
                points2D.set(i, new Point2D(((Point2D)points2D.get(i)).getX() + 1.0E-4, ((Point2D)points2D.get(i)).getY()));
                hasBeenChanged = true;
            }
            if (hasBeenChanged) {
                ArrayList<Double> mask = new ArrayList<Double>();
                MaskFunctionImpl function = ((DiscreteFunction2Panel)DiscreteFunction2Panel.this).model.function;
                for (int i = 0; i < points2D.size(); ++i) {
                    mask.add(function.getMask(function.points().get(i)));
                }
                MaskFunction emission = Factory.functionFactory().maskFunction(points2D, mask);
                DiscreteFunction2Panel.this.model.setDiscreteFunction2((MaskFunctionImpl)emission);
            }
        }
    }
}

