/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class BorderPanelLayout
implements LayoutManager2 {
    public static final String MAIN = "Main";
    public static final String TITLE_WIDGET = "TitleWidget";
    private static final int TITLE_MAIN_VERTICAL_SPACE = 1;
    private static final int TITLE_INDENT_SPACE = 14;
    private static final int TITLE_WIDGETS_SPACE = 4;
    private static final int TITLE_TOP_SPACE = 2;
    private static final int MAIN_PADDING = 2;
    private Component mainComponent;
    private List<Component> titleWidgets = new ArrayList<Component>();

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (MAIN.equals(name)) {
            this.mainComponent = comp;
        } else if (TITLE_WIDGET.equals(name)) {
            this.titleWidgets.add(comp);
        } else {
            throw new IllegalArgumentException("Cannot add to layout, unknown constraint: " + name);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("Cannot add to layout, constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this.mainComponent) {
            this.mainComponent = null;
        } else {
            this.titleWidgets.remove(comp);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension mainSize = this.mainComponent.getPreferredSize();
        int titleWidgetsHeight = this.getTitleWidgetsMaxHeight();
        int titleWidgetsWidth = this.getTitleWidgetsTotalWidth();
        Dimension result = new Dimension(Math.max(titleWidgetsWidth, mainSize.width + 4), titleWidgetsHeight + mainSize.height + 1 + 2 + 2);
        this.addInsetsToSize(target, result);
        return result;
    }

    private int getTitleWidgetsMaxHeight() {
        int result = 0;
        for (Component c : this.titleWidgets) {
            if (c.getPreferredSize().height <= result) continue;
            result = c.getPreferredSize().height;
        }
        return result;
    }

    private int getTitleWidgetsTotalWidth() {
        int result = 14;
        for (Component c : this.titleWidgets) {
            result += c.getPreferredSize().width;
        }
        return result += 4 * (this.titleWidgets.size() - 1);
    }

    private void addInsetsToSize(Container target, Dimension size) {
        Insets insets = target.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension mainSize = this.mainComponent.getMinimumSize();
        int titleWidgetsHeight = this.getTitleWidgetsMaxHeight();
        int titleWidgetsWidth = this.getTitleWidgetsTotalWidth();
        Dimension result = new Dimension(Math.max(titleWidgetsWidth, mainSize.width + 4), titleWidgetsHeight + mainSize.height + 1 + 2 + 2);
        this.addInsetsToSize(target, result);
        return result;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container target) {
        int titleWidgetsHeight = this.getTitleWidgetsMaxHeight();
        Insets insets = target.getInsets();
        this.mainComponent.setBounds(insets.left + 2, insets.top + titleWidgetsHeight + 1 + 2, target.getWidth() - insets.right - insets.left - 4, target.getHeight() - insets.bottom - insets.top - titleWidgetsHeight - 1 - 2 - 2);
        int titleWidgetLeft = insets.left + 14;
        for (Component titleWidget : this.titleWidgets) {
            Dimension widgetSize = titleWidget.getPreferredSize();
            int widgetCenterAlignAdjustment = (titleWidgetsHeight - widgetSize.height) / 2;
            titleWidget.setBounds(titleWidgetLeft, insets.top + widgetCenterAlignAdjustment + 2, widgetSize.width, widgetSize.height);
            titleWidgetLeft += widgetSize.width + 4;
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

