/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import javax.swing.JComponent;
import org.seamcat.presentation.components.BorderPanel;

public class BorderPanelBuilder {
    private JComponent component;
    private String title;
    private String helpText;
    private String helpLink;
    private String infoText;

    public BorderPanelBuilder(JComponent component, String title) {
        this.component = component;
        this.title = title;
    }

    public BorderPanelBuilder help(String helpText, String helpLink) {
        this.helpText = helpText;
        this.helpLink = helpLink;
        return this;
    }

    public BorderPanelBuilder info(String infoText) {
        this.infoText = infoText;
        return this;
    }

    public BorderPanel build() {
        if (this.info() && this.help()) {
            return new BorderPanel(this.component, this.title, this.helpText, this.helpLink, this.infoText);
        }
        if (this.info()) {
            return new BorderPanel(this.component, this.title, this.infoText);
        }
        if (this.help()) {
            return new BorderPanel(this.component, this.title, this.helpText, this.helpLink);
        }
        return new BorderPanel(this.component, this.title);
    }

    private boolean info() {
        return this.infoText != null;
    }

    private boolean help() {
        return this.helpText != null;
    }
}

