/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.components;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputAdapter;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.components.BorderPanelLayout;

public class BorderPanel
extends JPanel {
    JComponent innerPanel;
    JLabel titleLabel;
    JLabel informationIconLabel;
    JLabel helpButton;

    public BorderPanel() {
        this.setLayout(new BorderPanelLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(UIManager.getFont("TitledBorder.font"));
        this.titleLabel.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.add((Component)this.titleLabel, "TitleWidget");
        this.helpButton = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_HELP", 0));
        this.add((Component)this.helpButton, "TitleWidget");
        this.helpButton.setVisible(false);
        this.informationIconLabel = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_INFORMATION", 0));
        this.add((Component)this.informationIconLabel, "TitleWidget");
        this.informationIconLabel.setVisible(false);
    }

    public BorderPanel(JComponent innerPanel, String title) {
        this();
        this.setInnerPanel(innerPanel);
        this.setTitle(title);
    }

    public BorderPanel(JComponent innerPanel, String title, String infoText) {
        this();
        this.setInnerPanel(innerPanel);
        this.setTitle(title);
        this.setInformationText(infoText);
    }

    public BorderPanel(JComponent innerPanel, String title, String helpText, String helpLink) {
        this();
        this.setInnerPanel(innerPanel);
        this.setTitle(title);
        this.setHelpTextAndLink(helpText, helpLink);
    }

    public BorderPanel(JComponent innerPanel, String title, String helpText, String helpLink, String infoText) {
        this();
        this.setInnerPanel(innerPanel);
        this.setTitle(title);
        this.setHelpTextAndLink(helpText, helpLink);
        this.setInformationText(infoText);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    private void setInnerPanel(JComponent innerPanel) {
        this.innerPanel = innerPanel;
        innerPanel.setBorder(new TitledBorder((String)null));
        this.add((Component)innerPanel, "Main");
    }

    private void setInformationText(String text) {
        if (text != null) {
            this.informationIconLabel.setToolTipText(text);
            this.informationIconLabel.setVisible(true);
        } else {
            this.informationIconLabel.setVisible(false);
        }
    }

    private void setHelpTextAndLink(String helpText, final String helpLink) {
        this.helpButton.setToolTipText(helpText);
        this.helpButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SeamcatHelpResolver.showHelp(helpLink);
            }
        });
        this.helpButton.setVisible(true);
    }
}

