/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeListener;
import org.seamcat.presentation.compare.JCheckBoxList;

public class JCheckBoxListPanel
extends JPanel {
    private final JCheckBoxList list;

    public JCheckBoxListPanel(final ListModel<JCheckBox> listModel, final ChangeListener listener) {
        super(new BorderLayout());
        this.list = new JCheckBoxList(listModel, listener);
        JPanel buttons = new JPanel(new FlowLayout(0));
        JButton all = new JButton("Select all");
        buttons.add(all);
        all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxListPanel.this.setSelection(true, listModel, listener);
            }
        });
        JButton none = new JButton("Deselect all");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxListPanel.this.setSelection(false, listModel, listener);
            }
        });
        buttons.add(none);
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)buttons, "South");
    }

    private void setSelection(boolean selected, ListModel<JCheckBox> listModel, ChangeListener listener) {
        for (int i = 0; i < listModel.getSize(); ++i) {
            JCheckBox at = listModel.getElementAt(i);
            at.setSelected(selected);
        }
        listener.stateChanged(null);
        this.list.updateUI();
    }
}

