/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.compare;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

public class JCheckBoxList
extends JList<JCheckBox> {
    private static Border border = new EmptyBorder(1, 1, 1, 1);

    public JCheckBoxList(ListModel<JCheckBox> model, final ChangeListener listener) {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = JCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)JCheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    JCheckBoxList.this.repaint();
                    listener.stateChanged(null);
                }
            }
        });
        this.setSelectionMode(0);
        this.setModel(model);
    }

    private class CellRenderer
    implements ListCellRenderer<JCheckBox> {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = value;
            checkbox.setBackground(isSelected ? JCheckBoxList.this.getSelectionBackground() : JCheckBoxList.this.getBackground());
            checkbox.setForeground(isSelected ? JCheckBoxList.this.getSelectionForeground() : JCheckBoxList.this.getForeground());
            checkbox.setEnabled(JCheckBoxList.this.isEnabled());
            checkbox.setFont(JCheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(border);
            return checkbox;
        }
    }
}

