/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.compare;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.FileDialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.compare.CheckBoxTreeCellRenderer;
import org.seamcat.presentation.compare.FunctionNode;
import org.seamcat.presentation.compare.NodeHandler;
import org.seamcat.presentation.compare.VectorNode;
import org.seamcat.presentation.compare.WorkspaceVectors;
import org.seamcat.presentation.display.FunctionPanel;
import org.seamcat.presentation.display.NamedVectorResult;
import org.seamcat.presentation.display.VectorGroupResultType;
import org.seamcat.presentation.display.VectorPanel;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.propagationtest.AddRemovePanel;
import org.seamcat.presentation.propagationtest.VectorHolder;
import org.seamcat.simulation.result.SimulationResultImpl;
import org.seamcat.tabulardataio.FileDataIO;

public class CompareDialog
extends EscapeDialog
implements AddRemovePanel.AddRemoveListener,
TreeSelectionListener {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final String EXTERNAL = "External";
    private static final String WORKSPACES = "Workspaces";
    private VectorPanel vectorPanel;
    private FunctionPanel functionPanel;
    private CardLayout detail = new CardLayout();
    private JPanel detailPanel = new JPanel(this.detail);
    private static String VECTOR = "vectors";
    private static String FUNCTION = "functions";
    private String showing;
    private JTree tree;
    private JPanel treePanel;
    private AddRemovePanel addRemovePanel;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode externalRoot;
    private List<DefaultMutableTreeNode> selected = new ArrayList<DefaultMutableTreeNode>();
    private DefaultTreeModel model;

    public CompareDialog(JFrame owner, List<WorkspaceVectors> resultVectors) {
        super((Frame)owner, true);
        this.setLayout(new BorderLayout());
        this.root = new DefaultMutableTreeNode("Root");
        DefaultMutableTreeNode workspaceRoot = new DefaultMutableTreeNode(WORKSPACES);
        this.addRemovePanel = new AddRemovePanel();
        this.addRemovePanel.addAddRemoveListener(this);
        this.addRemovePanel.setAddToolTip(STRINGLIST.getString("COMPARE_VECTOR_BTN_REMOVE"));
        this.addRemovePanel.setAddToolTip(STRINGLIST.getString("COMPARE_VECTOR_BTN_ADD"));
        this.addRemovePanel.enableRemove(false);
        this.addRemovePanel.setLabelText(STRINGLIST.getString("COMPARE_VECTOR_ADD_REMOVE_LABEL"));
        this.populateTree(workspaceRoot, resultVectors);
        this.model = new DefaultTreeModel(this.root);
        this.root.add(workspaceRoot);
        this.tree = new JTree(this.root);
        this.tree.setCellRenderer(new CheckBoxTreeCellRenderer(this.tree.getCellRenderer()));
        this.tree.setModel(this.model);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    CompareDialog.this.selectedNode(CompareDialog.this.tree.getPathForLocation(e.getX(), e.getY()), new NodeHandler(){

                        @Override
                        public void handle(VectorNode node) {
                            CompareDialog.this.updateTitle(node);
                        }

                        @Override
                        public void handle(FunctionNode node) {
                        }
                    });
                } else {
                    CompareDialog.this.handleSelection(CompareDialog.this.tree.getPathForLocation(e.getX(), e.getY()));
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CompareDialog.this.handleSelection(CompareDialog.this.tree.getSelectionPath());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(300, scrollPane.getPreferredSize().height));
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.setBorder(new TitledBorder(STRINGLIST.getString("COMPARE_VECTOR_TREE_TITLE")));
        this.treePanel.add((Component)this.addRemovePanel, "North");
        this.treePanel.add((Component)scrollPane, "Center");
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.vectorPanel = new VectorPanel(this);
        this.vectorPanel.show((double[])null, "", "", "");
        this.functionPanel = new FunctionPanel(this);
        this.detailPanel.add(VECTOR, this.vectorPanel);
        this.detailPanel.add(FUNCTION, this.functionPanel);
        this.showing = VECTOR;
        this.setDefaultCloseOperation(2);
    }

    private void selectedNode(TreePath path, NodeHandler handler) {
        if (path != null) {
            Object last = path.getLastPathComponent();
            if (last instanceof VectorNode) {
                handler.handle((VectorNode)last);
            } else if (last instanceof FunctionNode) {
                handler.handle((FunctionNode)last);
            }
        }
    }

    private boolean showing(String name) {
        return name.equals(this.showing);
    }

    private void handleSelection(TreePath path) {
        this.selectedNode(path, new NodeHandler(){

            @Override
            public void handle(VectorNode node) {
                if (CompareDialog.this.selected.isEmpty()) {
                    CompareDialog.this.detail.show(CompareDialog.this.detailPanel, VECTOR);
                    CompareDialog.this.showing = VECTOR;
                }
                if (!CompareDialog.this.showing(VECTOR)) {
                    return;
                }
                boolean isSelected = node.getCheckBox().isSelected();
                if (!isSelected) {
                    VectorNode next;
                    String wantedUnit = node.getHolder().getUnit();
                    if (!CompareDialog.this.selected.isEmpty() && !wantedUnit.equals((next = (VectorNode)CompareDialog.this.selected.get(0)).getHolder().getUnit())) {
                        return;
                    }
                }
                CompareDialog.this.modify(node, isSelected);
                node.getCheckBox().setSelected(!isSelected);
                CompareDialog.this.vectorPanel.reset();
                if (!CompareDialog.this.selected.isEmpty()) {
                    ArrayList<VectorHolder> holders = new ArrayList<VectorHolder>();
                    String unit = "";
                    for (DefaultMutableTreeNode vn : CompareDialog.this.selected) {
                        VectorNode n = (VectorNode)vn;
                        holders.add(n.getHolder());
                        unit = n.getHolder().getUnit();
                    }
                    CompareDialog.this.vectorPanel.showL(holders, "", unit, "Events");
                } else {
                    CompareDialog.this.vectorPanel.show((double[])null, "", "", "");
                }
                CompareDialog.this.model.reload(node);
            }

            @Override
            public void handle(FunctionNode node) {
                if (CompareDialog.this.selected.isEmpty()) {
                    CompareDialog.this.detail.show(CompareDialog.this.detailPanel, FUNCTION);
                    CompareDialog.this.showing = FUNCTION;
                }
                if (!CompareDialog.this.showing(FUNCTION)) {
                    return;
                }
                boolean isSelected = node.getCheckBox().isSelected();
                if (!isSelected) {
                    FunctionNode first;
                    UniqueValueDef value;
                    String wantedDomain = node.getFunction().def().unit();
                    String wantedRange = node.getFunction().def().yUnit();
                    if (!(CompareDialog.this.selected.isEmpty() || wantedDomain.equals((value = (first = (FunctionNode)CompareDialog.this.selected.get(0)).getFunction().def()).unit()) && wantedRange.equals(value.yUnit()))) {
                        return;
                    }
                }
                CompareDialog.this.modify(node, isSelected);
                node.getCheckBox().setSelected(!isSelected);
                ArrayList<FunctionResultType> functions = new ArrayList<FunctionResultType>();
                if (!CompareDialog.this.selected.isEmpty()) {
                    for (DefaultMutableTreeNode vn : CompareDialog.this.selected) {
                        functions.add(((FunctionNode)vn).getFunction());
                    }
                }
                CompareDialog.this.functionPanel.setModel(functions);
                CompareDialog.this.model.reload(node);
            }
        });
    }

    private void modify(DefaultMutableTreeNode node, boolean remove) {
        if (remove) {
            this.selected.remove(node);
        } else {
            this.selected.add(node);
        }
    }

    private void updateTitle(VectorNode node) {
        String changed = JOptionPane.showInputDialog("Change name", (Object)node.getHolder().getTitle());
        if (changed != null) {
            node.changeTitle(changed);
            this.model.reload(node);
        }
    }

    public void showDialog() {
        this.getContentPane().add((Component)this.treePanel, "West");
        this.getContentPane().add((Component)this.detailPanel, "Center");
        this.setTitle(STRINGLIST.getString("COMPARE_VECTOR_DIALOG_TITLE"));
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void populateTree(final DefaultMutableTreeNode workspaceTop, final List<WorkspaceVectors> resultVectors) {
        LongTaskSwingExecutor.execute(new LongTask<List<DefaultMutableTreeNode>>(){

            @Override
            public List<DefaultMutableTreeNode> process() throws Exception {
                ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
                for (WorkspaceVectors vectors : resultVectors) {
                    DefaultMutableTreeNode workspaceNode = new DefaultMutableTreeNode(vectors.getWorkspaceTitle());
                    SimulationResultImpl simulationResult = (SimulationResultImpl)vectors.getSimulationResult();
                    for (Results resultGroup : simulationResult.getSeamcatResults()) {
                        CompareDialog.this.addGroup(resultGroup, workspaceNode);
                    }
                    if (simulationResult.getEventProcessingResults() != null && simulationResult.getEventProcessingResults().size() > 0) {
                        for (Results eppResult : simulationResult.getEventProcessingResults()) {
                            CompareDialog.this.addGroup(eppResult, workspaceNode);
                        }
                    }
                    result.add(workspaceNode);
                }
                return result;
            }

            @Override
            public void done(List<DefaultMutableTreeNode> result) {
                for (DefaultMutableTreeNode node : result) {
                    workspaceTop.add(node);
                }
                CompareDialog.this.model.reload(CompareDialog.this.root);
            }
        });
    }

    private void addGroup(Results types, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode vectorParent = new DefaultMutableTreeNode(types.getName());
        boolean appended = false;
        for (VectorHolder holder : this.toPHs(types.getVectorResultTypes())) {
            vectorParent.add(new VectorNode(holder));
            appended = true;
        }
        for (FunctionResultType type : types.getFunctionResultTypes()) {
            vectorParent.add(new FunctionNode(type));
            appended = true;
        }
        if (appended) {
            parent.add(vectorParent);
        }
    }

    @Override
    public void add() {
        final FileDialogHelper helper = MainWindow.getInstance().fileDialogHelper.addVector(this);
        if (helper.selectionMade()) {
            LongTaskSwingExecutor.execute(new LongTask<Map<String, VectorHolder>>(){

                @Override
                public Map<String, VectorHolder> process() throws Exception {
                    LinkedHashMap<String, VectorHolder> holders = new LinkedHashMap<String, VectorHolder>();
                    FileDataIO fileio = new FileDataIO();
                    for (File file : helper.getSelectedFiles()) {
                        fileio.setFile(file);
                        VectorResultType vector = fileio.loadVector();
                        VectorHolder holder = new VectorHolder();
                        holder.setTitle(vector.getName());
                        holder.setData(vector.getValue().asArray());
                        holder.setUnit(vector.getUnit());
                        holder.init();
                        holders.put(file.getName(), holder);
                    }
                    return holders;
                }

                @Override
                public void done(Map<String, VectorHolder> result) {
                    for (Map.Entry<String, VectorHolder> entry : result.entrySet()) {
                        CompareDialog.this.addExternalVector(entry.getKey(), entry.getValue());
                    }
                }
            });
        }
    }

    @Override
    public void remove() {
        final TreePath path = this.tree.getSelectionPath();
        this.selectedNode(path, new NodeHandler(){

            @Override
            public void handle(VectorNode node) {
                Object[] objects = path.getPath();
                CompareDialog.this.model.removeNodeFromParent((MutableTreeNode)objects[objects.length - 2]);
                CompareDialog.this.modify(node, true);
                CompareDialog.this.vectorPanel.reset();
            }

            @Override
            public void handle(FunctionNode node) {
            }
        });
    }

    @Override
    public void help() {
        SeamcatHelpResolver.showHelp("http://confluence.seamcat.org/display/SH/2.19+Multiple+vectors+comparison");
    }

    private void addExternalVector(String fileName, VectorHolder holder) {
        if (this.externalRoot == null) {
            this.externalRoot = new DefaultMutableTreeNode(EXTERNAL);
            this.model.insertNodeInto(this.externalRoot, this.root, this.root.getChildCount());
        }
        DefaultMutableTreeNode externalNode = new DefaultMutableTreeNode(fileName);
        this.model.insertNodeInto(externalNode, this.externalRoot, this.externalRoot.getChildCount());
        this.model.insertNodeInto(new VectorNode(holder), externalNode, externalNode.getChildCount());
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        Object last = path.getLastPathComponent();
        boolean enable = false;
        if (last instanceof VectorNode) {
            enable = path.getPath()[1] == this.externalRoot;
        }
        this.addRemovePanel.enableRemove(enable);
    }

    private List<VectorHolder> groupPHs(List<VectorGroupResultType> vectors) {
        ArrayList<VectorHolder> result = new ArrayList<VectorHolder>();
        for (VectorGroupResultType vector : vectors) {
            for (NamedVectorResult vectorResult : vector.getVectorGroup()) {
                VectorHolder holder = new VectorHolder();
                holder.setTitle(vectorResult.getName());
                holder.setData(vectorResult.getVector().asArray());
                holder.setUnit(vector.getUnit());
                holder.init();
                result.add(holder);
            }
        }
        return result;
    }

    private List<VectorHolder> toPHs(List<VectorResultType> vectors) {
        ArrayList<VectorHolder> result = new ArrayList<VectorHolder>();
        for (VectorResultType vector : vectors) {
            VectorHolder holder = new VectorHolder();
            if (vector.def().isGrouped()) {
                holder.setTitle(vector.def().group() + ":" + vector.getName());
            } else {
                holder.setTitle(vector.getName());
            }
            holder.setData(vector.getValue().asArray());
            holder.setUnit(vector.getUnit());
            holder.init();
            result.add(holder);
        }
        return result;
    }
}

