/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.builder;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.builder.AsActionListener;
import org.seamcat.presentation.library.LibraryItemWrapper;

public class SelectableTablePanel
extends JPanel {
    protected DefaultTableModel model;
    protected int selectionRow;

    public SelectableTablePanel(int selectionRow) {
        this.selectionRow = selectionRow;
    }

    protected boolean selected(int row) {
        return (Boolean)this.model.getValueAt(row, this.selectionRow);
    }

    public void setAll(boolean enable) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.setValueAt(enable, i, this.selectionRow);
        }
    }

    public List<LibraryItem> selectedItems() {
        ArrayList<LibraryItem> list = new ArrayList<LibraryItem>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.selected(i)) continue;
            list.add((LibraryItem)((LibraryItemWrapper)this.model.getValueAt(i, 0)).getItem());
        }
        return list;
    }

    @AsActionListener(value="select")
    private void select() {
        this.setAll(true);
    }

    @AsActionListener(value="deselect")
    private void deselect() {
        this.setAll(false);
    }
}

