/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.batch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.seamcat.batch.BatchJobList;
import org.seamcat.model.Workspace;
import org.seamcat.presentation.Utils;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.batch.BatchView;

public class BatchWorkspacesView
extends JTabbedPane {
    private final BatchJobList list;

    public BatchWorkspacesView(final BatchView view, BatchJobList list) {
        this.list = list;
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WorkspaceView ws = (WorkspaceView)BatchWorkspacesView.this.getSelectedComponent();
                view.selectedTab(ws);
            }
        });
        for (Workspace workspace : list.getBatchJobs()) {
            this.addClosable(new WorkspaceView(workspace));
        }
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    protected void addView(WorkspaceView view) {
        this.list.addBatchJob(view.getWorkspace());
        this.addClosable(view);
        this.setSelectedIndex(this.getTabCount() - 1);
    }

    protected void removeView(WorkspaceView view) {
        Workspace ws = view.getWorkspace();
        if (view.close()) {
            this.list.remove(ws);
            this.remove(view);
        }
    }

    private void addClosable(final WorkspaceView view) {
        this.addTab(view.getWorkspaceName(), view);
        JPanel tab = Utils.closableTab(view.getWorkspaceName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchWorkspacesView.this.removeView(view);
            }
        });
        this.setTabComponentAt(this.getTabCount() - 1, tab);
    }

    public void exportSelected() {
        WorkspaceView view = (WorkspaceView)this.getSelectedComponent();
        if (view != null) {
            view.forceSave();
        }
    }

    public void duplicateSelected() {
        WorkspaceView view = (WorkspaceView)this.getSelectedComponent();
        if (view != null) {
            this.addView(view.duplicate());
        }
    }

    public BatchJobList getBachJob() {
        return this.list;
    }

    public void updateModel() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((WorkspaceView)this.getComponentAt(i)).updateModel();
        }
    }
}

