/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.batch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.seamcat.batch.BatchJobList;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.objectutils.WorkspaceCloneHelper;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.LoadedWorkspace;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.batch.BatchDescription;
import org.seamcat.presentation.batch.BatchIOHandler;
import org.seamcat.presentation.batch.BatchToolBar;
import org.seamcat.presentation.batch.BatchViewState;
import org.seamcat.presentation.batch.BatchWorkspacesView;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.scenario.ScenarioConsistencyCheck;

public class BatchView
extends JPanel {
    private final BatchJobList list;
    private BatchToolBar toolBar;
    private GenericPanelEditor<BatchDescription> idPanel;
    private BatchWorkspacesView workspaces;
    private BatchViewState state;

    public BatchView(String name, String description) {
        this(new BatchJobList(name, description));
        this.list.setAbsoluteLocation(Model.getWorkspacePath() + name + ".sbj");
    }

    public String getTitle() {
        return this.list.getName();
    }

    public void setTitle(String name) {
        this.list.setName(name);
    }

    public BatchView(BatchJobList list) {
        super(new BorderLayout());
        this.list = list;
        this.state = list.getViewState();
        this.toolBar = new BatchToolBar(this);
        this.workspaces = new BatchWorkspacesView(this, list);
        BatchDescription prototype = Factory.prototype(BatchDescription.class);
        Factory.when(prototype.description()).thenReturn(list.getDescription());
        this.idPanel = new GenericPanelEditor<BatchDescription>(MainWindow.getInstance(), BatchDescription.class, Factory.build(prototype));
        JPanel top = new JPanel(new GridLayout(1, 2));
        top.add(new BorderPanel(this.idPanel, "Batch Description"));
        top.add(new BorderPanel(this.toolBar, "Control"));
        this.add((Component)top, "North");
        this.add((Component)new BorderPanel(this.workspaces, "Workspaces"), "Center");
    }

    public boolean isIncrementalSave() {
        return this.list.getIncrementalSave();
    }

    public void setIncrementalSave(boolean incrementalSave) {
        this.list.setIncrementalSave(incrementalSave);
    }

    protected void handleNewWorkspace() {
        this.workspaces.addView(new WorkspaceView(MainWindow.getInstance().openDefaultWorkspace()));
    }

    protected void handleOpenWorkspace() {
        MainWindow.getInstance().openWorkspace(new LoadedWorkspace(){

            @Override
            public void loadedWorkspace(Workspace workspace) {
                BatchView.this.workspaces.addView(new WorkspaceView(workspace));
            }
        });
    }

    protected void handleDuplicateWorkspace() {
        this.workspaces.duplicateSelected();
    }

    protected void handleExportWorkspace() {
        this.workspaces.exportSelected();
    }

    protected void selectedTab(WorkspaceView view) {
        this.toolBar.updateEnablement(view);
    }

    public boolean okToSimulate() {
        this.workspaces.updateModel();
        List<Workspace> batchJobs = this.list.getBatchJobs();
        if (batchJobs.isEmpty()) {
            DialogHelper.noBatchesToRun();
            return false;
        }
        for (Workspace workspace : batchJobs) {
            workspace.createScenario();
            List<ConsistencyError> results = ScenarioConsistencyCheck.checkScenario(workspace.getScenario(), workspace.getName());
            if (MainWindow.displayScenarioCheckResults(results, false, true, MainWindow.getInstance())) continue;
            return false;
        }
        return true;
    }

    public boolean dirty() {
        BatchViewState current = this.list.getViewState();
        if (this.state.getDescription().equals(current.getDescription()) && this.state.isIncrementalSave() == current.isIncrementalSave() && this.state.getWorkspaces().size() == current.getWorkspaces().size()) {
            List<Workspace> wss = this.state.getWorkspaces();
            for (int i = 0; i < wss.size(); ++i) {
                if (WorkspaceCloneHelper.equals(wss.get(i), current.getWorkspaces().get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.dirty()) {
            int result = DialogHelper.closeDirtyBatch("");
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                return true;
            }
            this.save();
            return true;
        }
        return true;
    }

    public void save() {
        this.workspaces.updateModel();
        BatchJobList list = this.workspaces.getBachJob();
        list.setDescription(this.idPanel.getModel().description());
        BatchIOHandler.save(list);
        this.state = list.getViewState();
    }

    public BatchJobList getList() {
        return this.list;
    }

    public void consistencyCheck() {
        this.workspaces.updateModel();
        ArrayList<ConsistencyError> results = new ArrayList<ConsistencyError>();
        for (Workspace workspace : this.list.getBatchJobs()) {
            workspace.createScenario();
            results.addAll(ScenarioConsistencyCheck.checkScenario(workspace.getScenario(), workspace.getName()));
        }
        MainWindow.displayScenarioCheckResults(results, true, false, MainWindow.getInstance());
    }
}

