/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabButton
extends JButton {
    private MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public TabButton() {
        int size = 17;
        this.setPreferredSize(new Dimension(size, size));
        this.setToolTipText("Close this tab");
        this.setUI(new BasicButtonUI());
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
        this.addMouseListener(this.buttonMouseListener);
        this.setRolloverEnabled(true);
    }

    @Override
    public void updateUI() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getModel().isPressed()) {
            g2.translate(1, 1);
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.BLACK);
        if (this.getModel().isRollover()) {
            g2.setColor(Color.MAGENTA);
        }
        int delta = 6;
        g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
        g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
        g2.dispose();
    }
}

