/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.Workspace;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.VectorResultType;

public class SizeEstimator {
    private static final long SAVE_MEMORY_USAGE_PER_EVENT = 0L;
    private static final long SAVE_MEMORY_USAGE_FIXED_OVERHEAD = 0x2000000L;
    private static final long LOAD_MEMORY_USAGE_PER_EVENT = 0L;
    private static final long LOAD_MEMORY_USAGE_FIXED_OVERHEAD = 0x2000000L;
    private static final long FILE_SIZE_PER_DOUBLE = 9L;
    private static final long FILE_SIZE_FIXED_OVERHEAD = 5000L;
    private static final Logger logger = Logger.getLogger(SizeEstimator.class);

    public static long eventFileSizeEstimate(Workspace workspace) {
        return 9L * SizeEstimator.countOfDoublesToBeSaved(workspace) + 5000L;
    }

    public static long countOfDoublesToBeSaved(Workspace workspace) {
        if (workspace.getSimulationResults() == null) {
            return 0L;
        }
        return SizeEstimator.countDoubles(workspace.getSimulationResults().getSeamcatResults()) + SizeEstimator.countDoubles(workspace.getSimulationResults().getEventProcessingResults());
    }

    private static int countDoubles(List<Results> groups) {
        int doubles = 0;
        for (Results group : groups) {
            for (BarChartResultType bar : group.getBarChartResultTypes()) {
                doubles += bar.value().size() * 2;
            }
            for (VectorResultType vector : group.getVectorResultTypes()) {
                doubles += vector.getValue().size();
            }
            for (ScatterDiagramResultType scatter : group.getScatterDiagramResultTypes()) {
                doubles += scatter.value().size() * 2;
            }
        }
        return doubles;
    }

    public static boolean resultsTooLargeForSaveOrLoad(Workspace workspace) {
        long doubles = SizeEstimator.countOfDoublesToBeSaved(workspace);
        long intermediateMemoryRequiredForSave = doubles * 0L + 0x2000000L;
        long intermediateMemoryRequiredForLoad = doubles * 0L + 0x2000000L;
        long maxMemory = Runtime.getRuntime().maxMemory();
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long availableMemory = maxMemory - usedMemory;
        if (Math.max(intermediateMemoryRequiredForSave, intermediateMemoryRequiredForLoad) > availableMemory) {
            logger.info("Reported memory too low: Collecting garbage and trying again");
            Runtime.getRuntime().gc();
            usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            availableMemory = maxMemory - usedMemory;
        }
        logger.info("Memory reported by runtime - max: " + maxMemory + ", avail: " + availableMemory);
        logger.info("Memory required for save: " + intermediateMemoryRequiredForSave + " (values: " + doubles + ")");
        logger.info("Memory required for subsequent load: " + intermediateMemoryRequiredForLoad);
        return Math.max(intermediateMemoryRequiredForSave, intermediateMemoryRequiredForLoad) > availableMemory;
    }
}

