/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.seamcat.Seamcat;
import org.seamcat.model.factory.Model;

public class SeamcatJFileChooser
extends JFileChooser {
    private static final String FILE_DIALOG_PATH = "SEAMCAT_FILE_DIALOG_PATH";
    private static final String FILE_DIALOG_DIMENSION_X = "SEAMCAT_FILE_DIALOG_DIMENSION_X";
    private static final String FILE_DIALOG_DIMENSION_Y = "SEAMCAT_FILE_DIALOG_DIMENSION_Y";

    private static Preferences preferences() {
        return Preferences.userNodeForPackage(Seamcat.class);
    }

    public SeamcatJFileChooser() {
        super(SeamcatJFileChooser.preferences().get(FILE_DIALOG_PATH, Model.seamcatHome.getAbsolutePath() + File.separator + "workspaces"));
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent he) {
                SeamcatJFileChooser.this.grabFocusForTextField(SeamcatJFileChooser.this.getComponents());
            }
        });
    }

    private void grabFocusForTextField(Component[] c) {
        for (Component k : c) {
            if (k instanceof JTextField) {
                JTextField jt = (JTextField)k;
                jt.grabFocus();
                break;
            }
            if (!(k instanceof JPanel)) continue;
            JPanel jp = (JPanel)k;
            this.grabFocusForTextField(jp.getComponents());
        }
    }

    public SeamcatJFileChooser(boolean directoryOnly) {
        this();
        if (directoryOnly) {
            this.setFileSelectionMode(1);
        }
    }

    private void setDialogSize() {
        Dimension openWorkspaceDimensions = new Dimension(Integer.parseInt(SeamcatJFileChooser.preferences().get(FILE_DIALOG_DIMENSION_X, "589")), Integer.parseInt(SeamcatJFileChooser.preferences().get(FILE_DIALOG_DIMENSION_Y, "306")));
        this.setPreferredSize(openWorkspaceDimensions);
    }

    private void saveSettings() {
        SeamcatJFileChooser.preferences().put(FILE_DIALOG_PATH, this.getCurrentDirectory().getAbsolutePath());
        Dimension fileChooserSize = this.getSize();
        SeamcatJFileChooser.preferences().put(FILE_DIALOG_DIMENSION_X, "" + Double.valueOf(fileChooserSize.getWidth()).intValue());
        SeamcatJFileChooser.preferences().put(FILE_DIALOG_DIMENSION_Y, "" + Double.valueOf(fileChooserSize.getHeight()).intValue());
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogSize();
        int result = super.showOpenDialog(parent);
        this.saveSettings();
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogSize();
        int result = super.showSaveDialog(parent);
        this.saveSettings();
        return result;
    }
}

