/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import org.seamcat.Seamcat;
import org.seamcat.batch.BatchJobList;
import org.seamcat.calculator.Calculator;
import org.seamcat.commands.CancelLoadCommand;
import org.seamcat.commands.CloseAllWorkspaceCommand;
import org.seamcat.commands.CloseApplicationCommand;
import org.seamcat.commands.CloseOthersWorkspaceCommand;
import org.seamcat.commands.CloseUnmodifiedWorkspaceCommand;
import org.seamcat.commands.CloseWorkspaceCommand;
import org.seamcat.commands.DisplayAboutCommand;
import org.seamcat.commands.DisplayCompareVectorCommand;
import org.seamcat.commands.DisplayConfigurationCommand;
import org.seamcat.commands.DisplayDistributionTestCommand;
import org.seamcat.commands.DisplayHelpCommand;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.commands.DisplayLibraryCommand;
import org.seamcat.commands.DisplayPropagationTestCommand;
import org.seamcat.commands.DisplayReportErrorCommand;
import org.seamcat.commands.DisplayStatusBarCommand;
import org.seamcat.commands.DisplaySystemsLibraryCommand;
import org.seamcat.commands.DisplayTestCalculatorCommand;
import org.seamcat.commands.DisplayTestFunctionsCommand;
import org.seamcat.commands.DisplayVectorScatterCommand;
import org.seamcat.commands.DuplicateWorkspaceCommand;
import org.seamcat.commands.ExportLibraryCommand;
import org.seamcat.commands.ImportLibraryCommand;
import org.seamcat.commands.NewBatchCommand;
import org.seamcat.commands.NewWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceFileCommand;
import org.seamcat.commands.SaveAllWorkspacesCommand;
import org.seamcat.commands.SaveWorkspaceAsCommand;
import org.seamcat.commands.SaveWorkspaceCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.FileNotFoundEvent;
import org.seamcat.events.FileOpenedEvent;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.ProgressEvent;
import org.seamcat.events.SimulationCompleteEvent;
import org.seamcat.events.SimulationErrorEvent;
import org.seamcat.events.SimulationStartedEvent;
import org.seamcat.events.WorkspaceSavedEvent;
import org.seamcat.events.WorkspaceViewAddedEvent;
import org.seamcat.events.WorkspacesPaneEmptyEvent;
import org.seamcat.events.WorkspacesPaneNonEmptyEvent;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.interfaces.Dispatcher;
import org.seamcat.interfaces.ImportLibraryVisitor;
import org.seamcat.marshalling.LibraryMarshaller;
import org.seamcat.migration.BackwardMigrationNotSupportedException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.model.Library;
import org.seamcat.model.LibraryModel;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.DataSaver;
import org.seamcat.model.factory.Model;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.objectutils.WorkspaceCloneHelper;
import org.seamcat.presentation.BackendRequest;
import org.seamcat.presentation.CurrentView;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.DialogOptions;
import org.seamcat.presentation.FileDialogHelper;
import org.seamcat.presentation.FileFilters;
import org.seamcat.presentation.LoadedWorkspace;
import org.seamcat.presentation.LogoSplash;
import org.seamcat.presentation.ProgressDialog;
import org.seamcat.presentation.RecentlyUsed;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.StatusBar;
import org.seamcat.presentation.Utils;
import org.seamcat.presentation.Version;
import org.seamcat.presentation.Welcome;
import org.seamcat.presentation.WorkspaceCount;
import org.seamcat.presentation.WorkspaceView;
import org.seamcat.presentation.batch.BatchIOHandler;
import org.seamcat.presentation.batch.BatchSimulationView;
import org.seamcat.presentation.batch.BatchView;
import org.seamcat.presentation.compare.CompareDialog;
import org.seamcat.presentation.compare.WorkspaceVectors;
import org.seamcat.presentation.distributiontest.DistributionTestDialog;
import org.seamcat.presentation.emissiontest.EmissionMaskTestDialog;
import org.seamcat.presentation.genericgui.LongTaskFailable;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.library.LibraryExportDialog;
import org.seamcat.presentation.library.LibraryImportDialog;
import org.seamcat.presentation.library.LibraryItemListPanel;
import org.seamcat.presentation.library.SystemLibraryItemListPanel;
import org.seamcat.presentation.menu.Menus;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.propagationtest.PropagationTestPanel;
import org.seamcat.presentation.simulation.StoppableRunnable;
import org.seamcat.presentation.simulationview.SimulationView;
import org.seamcat.presentation.vectorscatter.VectorScatterDialog;

public final class MainWindow
extends JFrame {
    private static final Logger LOG = Logger.getLogger(MainWindow.class);
    public FileDialogHelper fileDialogHelper = new FileDialogHelper();
    private static final String ROOTID = "CLIENT_MODE";
    private static final String SPLASH = "SPLASH";
    private static boolean busySaving = false;
    private static final MainWindow singleton = new MainWindow();
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private RecentlyUsed recentlyUsed;
    private Welcome welcome;
    public static final ExecutorService singleThreadPool = Executors.newFixedThreadPool(1);
    private static final ExecutorService fileSaver = Executors.newFixedThreadPool(1);
    private Runnable simulation;
    private final Calculator calculator = new Calculator(this);
    private DistributionTestDialog distributionTest;
    private EmissionMaskTestDialog functionTest;
    private PropagationTestPanel propagationTestPanel;
    private final CardLayout rootLayout = new CardLayout();
    private final JPanel root = new JPanel(this.rootLayout);
    private final JTabbedPane workspacesPane = new JTabbedPane(1);
    private final StatusBar statusBar = new StatusBar();
    private ToolBar toolBar = new ToolBar();
    private Menus menus = new Menus();
    private CurrentView componentClose = new CurrentView(){

        @Override
        public void current(WorkspaceView view) {
            if (view.close()) {
                MainWindow.this.removeComponent(view);
            }
        }

        @Override
        public void current(SimulationView view) {
            if (view.close()) {
                MainWindow.this.removeComponent(view);
            }
        }

        @Override
        public void current(BatchView view) {
            if (view.close()) {
                MainWindow.this.removeComponent(view);
            }
        }

        @Override
        public void current(BatchSimulationView view) {
            if (view.close()) {
                MainWindow.this.removeComponent(view);
            }
        }
    };
    private final WindowListener eventHandlerWindow = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            MainWindow.this.handleCloseApplication(null);
        }
    };

    public static boolean displayScenarioCheckResults(List<ConsistencyError> results, boolean displayIfOk, boolean askEge, Component component) {
        boolean runEge;
        boolean outcomeOk = true;
        StringBuffer messages = new StringBuffer();
        for (ConsistencyError result : results) {
            outcomeOk &= false;
            messages.append("<li><u>").append(result.name());
            messages.append(":</u> ").append(result.message()).append("</li>");
        }
        if (!outcomeOk) {
            if (askEge) {
                int ans = DialogHelper.consistencyError(component, messages);
                runEge = ans == 0;
            } else {
                DialogHelper.consistencyErrorPre(component, messages);
                runEge = false;
            }
        } else {
            if (displayIfOk) {
                DialogHelper.consistencyOk(component);
            }
            runEge = true;
        }
        return runEge;
    }

    public static MainWindow getInstance() {
        return singleton;
    }

    @UIEventHandler
    public void handleSimulationCompleted(SimulationCompleteEvent event) {
        this.setCursorDefault();
    }

    @UIEventHandler
    public void handleDisplayConfiguration(DisplayConfigurationCommand command) {
        new DialogOptions(this).setVisible(true);
    }

    @UIEventHandler
    public void handleCloseApplication(CloseApplicationCommand command) {
        for (Component component : this.allViews()) {
            if (component instanceof WorkspaceView ? !((WorkspaceView)component).close() : (component instanceof SimulationView ? !((SimulationView)component).close() : (component instanceof BatchView ? !((BatchView)component).close() : component instanceof BatchSimulationView && !((BatchSimulationView)component).close()))) {
                return;
            }
            this.removeComponent(component);
        }
        Model.getInstance().persist();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saved model");
        }
        while (busySaving) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DataSaver.stop();
        Model.getSimulationPool().destroy();
        System.exit(0);
    }

    @UIEventHandler
    public void handleShowHelp(DisplayHelpCommand command) {
        SeamcatHelpResolver.showHelp(this);
    }

    @UIEventHandler
    public void handleShowInterferingLinkHelp(DisplayHelpNameCommand command) {
        SeamcatHelpResolver.showHelp(command.getName());
    }

    @UIEventHandler
    public void handleNewBatch(NewBatchCommand command) {
        String name = "Batch " + WorkspaceCount.getAndUpdateBatchCount();
        this.addWorkspaceViewToPanel(new BatchView(name, ""), name);
    }

    @UIEventHandler
    public void handleDuplicateWorkspace(DuplicateWorkspaceCommand command) {
        WorkspaceView view = this.currentWorkspaceView();
        if (view != null) {
            this.addWorkspaceViewToPanel(view.duplicate(), view.getWorkspaceName());
        }
    }

    @UIEventHandler
    public void handlePropagationTest(DisplayPropagationTestCommand command) {
        if (this.propagationTestPanel == null) {
            this.propagationTestPanel = new PropagationTestPanel(this);
        }
        this.propagationTestPanel.setVisible(true);
    }

    @UIEventHandler
    public void handleTestFunctions(DisplayTestFunctionsCommand command) {
        if (this.functionTest == null) {
            this.functionTest = new EmissionMaskTestDialog(this);
        }
        this.functionTest.setVisible(true);
    }

    @UIEventHandler
    public void handleTestCalculator(DisplayTestCalculatorCommand command) {
        this.calculator.setVisible(true);
    }

    @UIEventHandler
    public void handleReportError(DisplayReportErrorCommand command) {
        DialogHelper.reportError();
    }

    @UIEventHandler
    public void handleCompareVector(DisplayCompareVectorCommand command) {
        ArrayList<WorkspaceVectors> vectorList = new ArrayList<WorkspaceVectors>();
        for (SimulationView simulationView : this.simulationViews()) {
            vectorList.add(simulationView.getResultVectors());
        }
        for (BatchSimulationView batchSimulationView : this.batchSimulationViews()) {
            vectorList.addAll(batchSimulationView.getResultVectors());
        }
        new CompareDialog(this, vectorList).showDialog();
    }

    @UIEventHandler
    public void handleVectorScatter(DisplayVectorScatterCommand command) {
        ArrayList<WorkspaceVectors> vectorList = new ArrayList<WorkspaceVectors>();
        for (SimulationView simulationView : this.simulationViews()) {
            vectorList.add(simulationView.getResultVectors());
        }
        for (BatchSimulationView batchSimulationView : this.batchSimulationViews()) {
            vectorList.addAll(batchSimulationView.getResultVectors());
        }
        new VectorScatterDialog(this, vectorList).showDialog();
    }

    @UIEventHandler
    public void handleAbout(DisplayAboutCommand command) {
        DialogHelper.about();
    }

    @UIEventHandler
    public void handleDistributionTest(DisplayDistributionTestCommand command) {
        if (this.distributionTest == null) {
            this.distributionTest = new DistributionTestDialog(this);
        }
        this.distributionTest.setVisible(true);
    }

    @UIEventHandler
    public void handleNewWorkspace(NewWorkspaceCommand command) {
        Workspace workspace = this.openDefaultWorkspace();
        this.addWorkspaceViewToPanel(new WorkspaceView(workspace), workspace.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace openDefaultWorkspace() {
        Workspace workspace;
        long begin = System.currentTimeMillis();
        this.setCursorBusy();
        try {
            Workspace workspace2 = Model.openDefaultWorkspace();
            workspace2.setName(workspace2.getName() + " " + WorkspaceCount.getAndUpdateCount());
            workspace = workspace2;
        }
        catch (Throwable throwable) {
            EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("Loaded workspace in %d millis", System.currentTimeMillis() - begin)));
            this.setCursorDefault();
            throw throwable;
        }
        EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("Loaded workspace in %d millis", System.currentTimeMillis() - begin)));
        this.setCursorDefault();
        return workspace;
    }

    @UIEventHandler
    public void handleOpenWorkspace(OpenWorkspaceCommand command) {
        this.openWorkspace(new LoadedWorkspace());
    }

    @UIEventHandler
    public void handleSaveWorkspace(SaveWorkspaceCommand command) {
        this.currentView(new CurrentView(){

            @Override
            public void current(WorkspaceView view) {
                view.save();
            }

            @Override
            public void current(SimulationView view) {
                view.save();
            }

            @Override
            public void current(BatchView view) {
                view.save();
            }

            @Override
            public void current(BatchSimulationView view) {
                view.save();
            }
        });
    }

    @UIEventHandler
    public void handleSaveWorkspaceAs(SaveWorkspaceAsCommand command) {
        this.currentView(new CurrentView(){

            @Override
            public void current(WorkspaceView view) {
                File file = MainWindow.this.saveWorksaceAs(FileFilters.FILE_FILTER_WORKSPACE);
                if (file != null) {
                    view.saveWorkspaceAs(file);
                    MainWindow.this.setTabTitle(view, view.getWorkspaceName());
                }
            }

            @Override
            public void current(SimulationView view) {
                File file = MainWindow.this.saveWorksaceAs(FileFilters.FILE_FILTER_WORKSPACE_RESULT);
                if (file != null) {
                    view.saveWorkspaceAs(file);
                    MainWindow.this.setTabTitle(view, "Results[" + view.getWorkspace().getName() + "]");
                }
            }

            @Override
            public void current(BatchView view) {
                File file = MainWindow.this.saveWorksaceAs(FileFilters.FILE_FILTER_BATCH);
                if (file != null) {
                    view.getList().setAbsoluteLocation(file.getAbsolutePath());
                    view.setTitle(Utils.filenameWithoutExtension(file));
                    view.save();
                    MainWindow.this.setTabTitle(view, view.getTitle());
                }
            }

            @Override
            public void current(BatchSimulationView view) {
                File file = MainWindow.this.saveWorksaceAs(FileFilters.FILE_FILTER_BATCH_RESULT);
                if (file != null) {
                    view.getJobList().setAbsoluteLocation(file.getAbsolutePath());
                    view.setTitle(Utils.filenameWithoutExtension(file));
                    view.save();
                    MainWindow.this.setTabTitle(view, "Results[" + view.getTitle() + "]");
                }
            }
        });
    }

    @UIEventHandler
    public void handleCloseAll(CloseAllWorkspaceCommand command) {
        for (Component component : this.workspacesPane.getComponents()) {
            this.closeComponent(component);
        }
    }

    @UIEventHandler
    public void handleCloseOthers(CloseOthersWorkspaceCommand command) {
        Component selected = this.workspacesPane.getSelectedComponent();
        for (Component component : this.workspacesPane.getComponents()) {
            if (component == selected) continue;
            this.closeComponent(component);
        }
    }

    @UIEventHandler
    public void handleCloseUnmodified(CloseUnmodifiedWorkspaceCommand command) {
        for (Component component : this.workspacesPane.getComponents()) {
            if (component instanceof WorkspaceView) {
                if (((WorkspaceView)component).dirty()) continue;
                this.closeComponent(component);
                continue;
            }
            if (component instanceof SimulationView) {
                if (((SimulationView)component).dirty()) continue;
                this.closeComponent(component);
                continue;
            }
            if (component instanceof BatchView) {
                if (((BatchView)component).dirty()) continue;
                this.closeComponent(component);
                continue;
            }
            if (!(component instanceof BatchSimulationView) || ((BatchSimulationView)component).dirty()) continue;
            this.closeComponent(component);
        }
    }

    private void closeComponent(Component component) {
        if (component instanceof WorkspaceView) {
            if (((WorkspaceView)component).close()) {
                this.removeComponent(component);
            }
        } else if (component instanceof SimulationView) {
            if (((SimulationView)component).close()) {
                this.removeComponent(component);
            }
        } else if (component instanceof BatchView) {
            if (((BatchView)component).close()) {
                this.removeComponent(component);
            }
        } else if (component instanceof BatchSimulationView && ((BatchSimulationView)component).close()) {
            this.removeComponent(component);
        }
    }

    @UIEventHandler
    public void handleCloseWorkspace(CloseWorkspaceCommand command) {
        this.currentView(this.componentClose);
        System.gc();
    }

    @UIEventHandler
    public void handleImportLibrary(ImportLibraryCommand command) {
        if (this.fileDialogHelper.importLibrary(this).selectionMade()) {
            try {
                File settingsFile = this.fileDialogHelper.getSelectedFile();
                if (settingsFile == null) {
                    throw new NullPointerException();
                }
                Model.getInstance();
                LibraryModel model = LibraryMarshaller.loadAndParseSettingsFile(settingsFile, Model.getPrehistoricSettingsFile());
                Library imported = new Library(model);
                LibraryImportDialog dialog = new LibraryImportDialog(this, imported);
                if (this.selectImportLibraries(dialog)) {
                    List<LibraryItem> selected = dialog.selectedItems();
                    ImportLibraryVisitor importer = new ImportLibraryVisitor();
                    for (LibraryItem identifiable : selected) {
                        Dispatcher.dispatch(importer, identifiable);
                    }
                    Model.getInstance().getLibrary().ensureConsistentLibrary();
                    Model.getInstance().persist();
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format(STRINGLIST.getString("IMPORT_LIBRARY_OK"), settingsFile.getAbsolutePath())));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LOG.error(exception);
                DialogHelper.invalidFile();
            }
        }
    }

    private boolean selectImportLibraries(LibraryImportDialog dialog) {
        boolean selecting = true;
        while (selecting) {
            if (dialog.display()) {
                List<LibraryItem> duplicateNames = dialog.findDuplicateNames();
                if (!duplicateNames.isEmpty()) {
                    DialogHelper.importLibraryNameConflict(duplicateNames);
                    continue;
                }
                selecting = false;
                continue;
            }
            selecting = false;
        }
        return dialog.isAccept();
    }

    @UIEventHandler
    public void handleExportLibrary(ExportLibraryCommand command) {
        LibraryExportDialog dialog = new LibraryExportDialog(this);
        if (dialog.display() && this.fileDialogHelper.exportLibrary(this).selectionMade()) {
            File f = this.fileDialogHelper.getSelectedFile();
            if (!f.getName().toUpperCase().endsWith(".SLI")) {
                f = new File(f.getAbsolutePath() + ".sli");
            }
            new LibraryMarshaller().exportLibrary(dialog.selectedItems(), f);
            EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format(STRINGLIST.getString("SAVE_LIBRARY_DONE"), f.getAbsolutePath())));
        }
    }

    public void runBatch(BatchView view) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        BatchJobList jobList = view.getList();
        BatchJobList clone = new BatchJobList(jobList.getName(), jobList.getDescription());
        for (Workspace ws : jobList.getBatchJobs()) {
            clone.addBatchJob(this.cloneForSimulation(ws));
        }
        if (jobList.hasLocation()) {
            File file = new File(jobList.getAbsoluteLocation());
            clone.setAbsoluteLocation(file.getParentFile().getAbsolutePath() + File.separator + jobList.getName() + ".sbr");
        }
        final BatchSimulationView batchView = new BatchSimulationView(clone);
        batchView.setIncrementalSave(view.isIncrementalSave());
        this.addWorkspaceViewToPanel(batchView, "Results[" + clone.getName() + "]");
        EventBusFactory.getEventBus().publish(new SimulationStartedEvent(null));
        this.simulation = new StoppableRunnable(){

            @Override
            public void stop() {
            }

            @Override
            public void run() {
                try {
                    batchView.startSimulation();
                }
                catch (SimulationInvalidException e) {
                    EventBusFactory.getEventBus().publish(new SimulationErrorEvent(batchView, e));
                }
            }
        };
        singleThreadPool.submit(this.simulation);
    }

    public void run(WorkspaceView view) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Workspace clone = this.cloneForSimulation(view.getWorkspace());
        clone.createScenario();
        final SimulationView simulationView = new SimulationView(clone, true);
        this.addWorkspaceViewToPanel(simulationView, "Results[" + clone.getName() + "]");
        EventBusFactory.getEventBus().publish(new SimulationStartedEvent(null));
        this.simulation = new Runnable(){

            @Override
            public void run() {
                try {
                    simulationView.simulate();
                }
                catch (SimulationInvalidException e) {
                    EventBusFactory.getEventBus().publish(new SimulationErrorEvent(simulationView, e));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    MainWindow.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        singleThreadPool.submit(this.simulation);
    }

    private Workspace cloneForSimulation(Workspace workspace) {
        Workspace clone = WorkspaceCloneHelper.clone(workspace);
        clone.prune();
        clone.setScenario(workspace.getScenario());
        clone.getInterferenceLinks().addAll(workspace.getInterferenceLinks());
        clone.prepareSimulate();
        return clone;
    }

    @UIEventHandler
    public void handleSimulationError(SimulationErrorEvent event) {
        this.workspacesPane.remove(event.getComponent());
        if (event.getE().getOrigin() != null) {
            DialogHelper.simulationError(event.getE());
            LOG.error("Simulation Error", event.getE().getOrigin());
        }
        this.setCursor(Cursor.getDefaultCursor());
        EventBusFactory.getEventBus().publish(new SimulationCompleteEvent());
    }

    @UIEventHandler
    public void handleDisplaySystemsLibrary(DisplaySystemsLibraryCommand command) {
        new SystemLibraryItemListPanel(this, "Systems library", "http://confluence.seamcat.org/display/SH/13.4.1+System+elements", 1400, 800).setVisible(true);
    }

    @UIEventHandler
    public void handleDisplayLibrary(DisplayLibraryCommand command) {
        new LibraryItemListPanel(this, command.getLibraryItemClass(), command.getTitle(), command.getHelpUrl(), command.getWidth(), command.getHeight(), command.getMinimumLibraryItemCount()).setVisible(true);
    }

    @UIEventHandler
    public void handleDisplayStatusBar(DisplayStatusBarCommand command) {
        this.statusBar.setVisible(!this.statusBar.isVisible());
    }

    @UIEventHandler
    public void handleSaveAllWorkspaces(SaveAllWorkspacesCommand command) {
        for (Component component : this.allViews()) {
            if (component instanceof WorkspaceView) {
                ((WorkspaceView)component).save();
                continue;
            }
            if (component instanceof SimulationView) {
                ((SimulationView)component).save();
                continue;
            }
            if (component instanceof BatchView) {
                ((BatchView)component).save();
                continue;
            }
            if (!(component instanceof BatchSimulationView)) continue;
            ((BatchSimulationView)component).save();
        }
    }

    @UIEventHandler
    public void handleOpenWorkspaceFile(OpenWorkspaceFileCommand command) {
        if (command.getFile().exists()) {
            this.handleOpen(command.getFile(), new LoadedWorkspace());
        } else {
            EventBusFactory.getEventBus().publish(new FileNotFoundEvent(command.getFile().getAbsolutePath()));
            String message = DialogHelper.saveFaildMessage(command.getFile().getAbsolutePath());
            EventBusFactory.getEventBus().publish(new InfoMessageEvent(message));
        }
    }

    public void openWorkspace(LoadedWorkspace loadedWorkspace) {
        if (this.fileDialogHelper.openWorkspace(this).selectionMade()) {
            for (File file : this.fileDialogHelper.getSelectedFiles()) {
                this.handleOpen(file, loadedWorkspace);
            }
        }
    }

    private void handleOpen(File file, LoadedWorkspace loadedWorkspace) {
        String path = file.getAbsolutePath();
        if (path.endsWith(".sbj") || path.endsWith(".sbr")) {
            BatchJobList jobList = BatchIOHandler.load(file);
            if (jobList == null) {
                return;
            }
            if (jobList.hasBeenCalculated()) {
                BatchSimulationView view = new BatchSimulationView(jobList);
                view.complete();
                this.addWorkspaceViewToPanel(view, "Results[" + jobList.getName() + "]");
            } else {
                this.addWorkspaceViewToPanel(new BatchView(jobList), jobList.getName());
            }
        } else {
            this.openWorkspace(file, loadedWorkspace);
        }
    }

    private File saveWorksaceAs(FileFilters.ExtensionFileFilter filter) {
        if (this.fileDialogHelper.saveWorkspaceAs(this, filter).selectionMade()) {
            return filter.align(this.fileDialogHelper.getSelectedFile());
        }
        return null;
    }

    public void saveWorkspace(final Workspace wks) {
        busySaving = true;
        final ProgressDialog progressDialog = new ProgressDialog(MainWindow.getInstance());
        progressDialog.setTitle("Saving workspace");
        progressDialog.setExplanation("Saving workspace: " + wks.getName());
        progressDialog.setProgressMessage("Saving workspace...");
        LongTaskSwingExecutor.execute(new LongTaskFailable(){

            @Override
            public Object process() throws Exception {
                Model.saveWorkspace(wks);
                File file = wks.getPath();
                EventBusFactory.getEventBus().publish(new WorkspaceSavedEvent(file.getAbsolutePath()));
                if (wks.isHasBeenCalculated()) {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(DialogHelper.getSaveDoneWithResultsString(file)));
                } else {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(DialogHelper.getSaveDoneString(file)));
                }
                return null;
            }

            @Override
            public void done(Object result) {
                busySaving = false;
                progressDialog.close();
            }

            @Override
            public void failed(Exception exception) {
                this.done((Object)null);
                LOG.error("Exception while saving", exception);
                DialogHelper.saveError();
            }
        });
        progressDialog.showModally();
    }

    private void openWorkspace(final File file, final LoadedWorkspace handler) {
        this.setCursorBusy();
        final ProgressDialog progressDialog = new ProgressDialog((Frame)this, new CancelLoadCommand());
        progressDialog.setTitle("Loading");
        progressDialog.setExplanation("Loading workspace " + file.getName());
        LongTaskSwingExecutor.execute(new LongTaskFailable<Workspace>(){

            @Override
            public Workspace process() throws Exception {
                EventBusFactory.getEventBus().publish(new ProgressEvent("Loading workspace"));
                return Model.openWorkspace(file);
            }

            @Override
            public void done(Workspace result) {
                progressDialog.close();
                if (result == null) {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("Cancelled loading of '%s'", file.getName())));
                } else {
                    List<MigrationIssue> issues = result.getMigrationIssues();
                    if (!issues.isEmpty()) {
                        StringBuilder sb = new StringBuilder("<html>Warnings when migrating: <br><br><ul>");
                        for (MigrationIssue issue : issues) {
                            sb.append("<li>").append(issue.getMessage()).append("</li>");
                        }
                        sb.append("</ul></html>");
                        JOptionPane.showMessageDialog(null, sb.toString(), "Migration Warning", 2);
                    }
                    EventBusFactory.getEventBus().publish(new FileOpenedEvent(file.getAbsolutePath()));
                    String name = file.getName();
                    result.setName(name.substring(0, name.lastIndexOf(".")));
                    handler.loadedWorkspace(result);
                }
            }

            @Override
            public void failed(Exception exception) {
                if (exception instanceof BackwardMigrationNotSupportedException) {
                    LOG.error("Backward migration not possible", exception);
                    DialogHelper.backwardMigrationNotSupported();
                } else {
                    LOG.error("Error opening workspace", exception);
                    DialogHelper.openWorkspaceError();
                }
                progressDialog.close();
            }
        });
        progressDialog.showModally();
    }

    protected void addWorkSpaceToView(Workspace loadedWorkspace) {
        if (loadedWorkspace.getPartial() != null) {
            this.addWorkspaceViewToPanel(new SimulationView(loadedWorkspace, loadedWorkspace.getPartial()), "Results[" + loadedWorkspace.getName() + "]");
        } else if (loadedWorkspace.isHasBeenCalculated()) {
            this.addWorkspaceViewToPanel(new SimulationView(loadedWorkspace), "Results[" + loadedWorkspace.getName() + "]");
        } else {
            this.addWorkspaceViewToPanel(new WorkspaceView(loadedWorkspace), loadedWorkspace.getName());
        }
    }

    private List<SimulationView> simulationViews() {
        Component[] views;
        ArrayList<SimulationView> currentViews = new ArrayList<SimulationView>();
        for (Component component : views = this.workspacesPane.getComponents()) {
            if (!(component instanceof SimulationView)) continue;
            currentViews.add((SimulationView)component);
        }
        return currentViews;
    }

    private List<BatchSimulationView> batchSimulationViews() {
        Component[] views;
        ArrayList<BatchSimulationView> currentViews = new ArrayList<BatchSimulationView>();
        for (Component component : views = this.workspacesPane.getComponents()) {
            if (!(component instanceof BatchSimulationView)) continue;
            currentViews.add((BatchSimulationView)component);
        }
        return currentViews;
    }

    private List<Component> allViews() {
        Component[] views;
        ArrayList<Component> currentViews = new ArrayList<Component>();
        for (Component component : views = this.workspacesPane.getComponents()) {
            if (component instanceof WorkspaceView) {
                currentViews.add(component);
                continue;
            }
            if (component instanceof SimulationView) {
                currentViews.add(component);
                continue;
            }
            if (component instanceof BatchView) {
                currentViews.add(component);
                continue;
            }
            if (!(component instanceof BatchSimulationView)) continue;
            currentViews.add(component);
        }
        return currentViews;
    }

    public void setCursorBusy() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setCursorDefault() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void addWorkspaceViewToPanel(Component view, String name) {
        this.rootLayout.show(this.root, ROOTID);
        this.workspacesPane.addTab(name, view);
        this.setTabTitle(view, name);
        if (view instanceof WorkspaceView) {
            EventBusFactory.getEventBus().publish(new WorkspaceViewAddedEvent((WorkspaceView)view));
        }
        if (this.workspacesPane.getTabCount() == 1) {
            EventBusFactory.getEventBus().publish(new WorkspacesPaneNonEmptyEvent());
        }
    }

    private void setTabTitle(final Component view, String name) {
        int index = this.workspacesPane.indexOfComponent(view);
        this.workspacesPane.setSelectedIndex(index);
        this.workspacesPane.setTabComponentAt(this.workspacesPane.indexOfComponent(view), Utils.closableTab(name, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.dispatchView(view, MainWindow.this.componentClose);
                System.gc();
            }
        }));
    }

    private void removeComponent(Component view) {
        int i = this.workspacesPane.indexOfComponent(view);
        this.workspacesPane.removeTabAt(i);
        this.workspacesPane.remove(view);
        this.setSplashIfEmpty();
    }

    private void setSplashIfEmpty() {
        if (this.workspacesPane.getTabCount() == 0) {
            this.rootLayout.show(this.root, SPLASH);
            EventBusFactory.getEventBus().publish(new WorkspacesPaneEmptyEvent());
        }
    }

    public void dispatchView(Component component, CurrentView handler) {
        if (component instanceof WorkspaceView) {
            handler.current((WorkspaceView)component);
        } else if (component instanceof SimulationView) {
            handler.current((SimulationView)component);
        } else if (component instanceof BatchView) {
            handler.current((BatchView)component);
        } else if (component instanceof BatchSimulationView) {
            handler.current((BatchSimulationView)component);
        }
    }

    public void currentView(CurrentView handler) {
        this.dispatchView(this.workspacesPane.getSelectedComponent(), handler);
    }

    public WorkspaceView currentWorkspaceView() {
        Component selectedComponent = this.workspacesPane.getSelectedComponent();
        if (selectedComponent instanceof WorkspaceView) {
            return (WorkspaceView)selectedComponent;
        }
        return null;
    }

    public SimulationView currentSimulationView() {
        Component selectedComponent = this.workspacesPane.getSelectedComponent();
        if (selectedComponent instanceof SimulationView) {
            return (SimulationView)selectedComponent;
        }
        return null;
    }

    private MainWindow() {
    }

    private void createMenuBar() {
        this.setJMenuBar(this.menus.createMenus(new JMenuBar()));
    }

    public void init() {
        this.calculator.setModal(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.eventHandlerWindow);
        this.setIconImage(SeamcatIcons.getImageIcon("SEAMCAT_ICON_SEAMCAT").getImage());
        this.setTitle(STRINGLIST.getString("APPLICATION_TITLE") + " - buildtime: " + STRINGLIST.getString("APPLICATION_BUILD_TIME"));
        this.createMenuBar();
        this.toolBar.createToolBar();
        this.getContentPane().add((Component)this.toolBar.getToolBar(), "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.root.add((Component)new LogoSplash(), SPLASH);
        this.root.add((Component)this.workspacesPane, ROOTID);
        this.getContentPane().add(this.root);
        EventBusFactory.getEventBus().subscribe(this.statusBar);
        this.statusBar.setLeft("SEAMCAT startup time in milliseconds: " + (System.currentTimeMillis() - Seamcat.ctm));
        this.setToolTip();
        this.recentlyUsed = new RecentlyUsed();
        this.welcome = new Welcome(this, "Welcome to SEAMCAT", true);
        this.recentlyUsed.refresh();
        new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                return BackendRequest.requestNews(STRINGLIST.getString("APPLICATION_TITLE"));
            }

            @Override
            protected void done() {
                try {
                    MainWindow.this.statusBar.setMiddle((String)this.get(), STRINGLIST.getString("NEWS_TOOLTIP"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute();
        new SwingWorker<Version, Void>(){

            @Override
            protected Version doInBackground() throws Exception {
                return BackendRequest.requestVersion();
            }

            @Override
            protected void done() {
                try {
                    Version version = (Version)this.get();
                    int major = Integer.parseInt(STRINGLIST.getString("APPLICATION_MAJOR"));
                    int minor = Integer.parseInt(STRINGLIST.getString("APPLICATION_MINOR"));
                    int patch = Integer.parseInt(STRINGLIST.getString("APPLICATION_PATCH"));
                    if (version.getMajor() > major) {
                        DialogHelper.versionWarning();
                        return;
                    }
                    if (version.getMinor() > minor) {
                        DialogHelper.versionMessage();
                        return;
                    }
                    if (version.getPatch() > patch) {
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent("A patched version of SEAMCAT is available for download"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute();
        fileSaver.submit(new DataSaver());
    }

    private void setToolTip() {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }
}

