/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

public class LabeledPairLayout
implements LayoutManager {
    public static final String FIELD = "field";
    public static final String LABEL = "label";
    protected Vector<JComponent> fields = new Vector();
    protected Vector<JComponent> labels = new Vector();
    protected int xGap = 2;
    protected int yGap = 2;

    protected static final int maxWidth(Collection<JComponent> comps) {
        int width = 0;
        for (JComponent comp : comps) {
            int localWidth = (int)comp.getPreferredSize().getWidth();
            width = Math.max(width, localWidth);
        }
        return width;
    }

    @Override
    public void addLayoutComponent(String s, Component c) {
        if (!(c instanceof JComponent)) {
            throw new IllegalArgumentException("Layoutcomponents must be of type JComponent");
        }
        if (s.equals(LABEL)) {
            this.labels.addElement((JComponent)c);
        } else if (s.equals(FIELD)) {
            this.fields.addElement((JComponent)c);
        }
    }

    public int getXGap() {
        return this.xGap;
    }

    public int getYGap() {
        return this.yGap;
    }

    @Override
    public void layoutContainer(Container c) {
        Insets insets = c.getInsets();
        int labelWidth = LabeledPairLayout.maxWidth(this.labels);
        int yPos = insets.top;
        Iterator<JComponent> lIt = this.labels.iterator();
        Iterator<JComponent> fIt = this.fields.iterator();
        while (lIt.hasNext() && fIt.hasNext()) {
            JComponent label = lIt.next();
            JComponent field = fIt.next();
            int height = Math.max(label.getPreferredSize().height, field.getPreferredSize().height);
            label.setBounds(insets.left, yPos, labelWidth, height);
            field.setBounds(insets.left + labelWidth + this.xGap, yPos, c.getSize().width - (labelWidth + this.xGap + insets.left + insets.right), height);
            yPos += height + this.yGap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        Insets insets = c.getInsets();
        int labelWidth = LabeledPairLayout.maxWidth(this.labels);
        int fieldWidth = LabeledPairLayout.maxWidth(this.fields);
        int yPos = insets.top;
        Iterator<JComponent> lIt = this.labels.iterator();
        Iterator<JComponent> fIt = this.fields.iterator();
        while (lIt.hasNext() && fIt.hasNext()) {
            JComponent label = lIt.next();
            JComponent field = fIt.next();
            int height = Math.max(label.getPreferredSize().height, field.getPreferredSize().height);
            yPos += height + this.yGap;
        }
        return new Dimension(labelWidth + fieldWidth, yPos += 2 * this.yGap);
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.labels.remove(c);
        this.fields.remove(c);
    }

    public void setXGap(int xGap) {
        this.xGap = xGap;
    }

    public void setYGap(int yGap) {
        this.yGap = yGap;
    }
}

