/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.seamcat.presentation.FileFilters;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.SeamcatJFileChooser;

public class FileDialogHelper {
    private final SeamcatJFileChooser FILECHOOSER = new SeamcatJFileChooser();
    private boolean selectionMade;

    private void setFileFilters(FileFilter ... filters) {
        this.FILECHOOSER.resetChoosableFileFilters();
        for (FileFilter filter : filters) {
            this.FILECHOOSER.setFileFilter(filter);
        }
    }

    public FileDialogHelper openWorkspace(Component owner) {
        this.setFileFilters(FileFilters.FILE_FILTER_WORKSPACE, FileFilters.FILE_FILTER_WORKSPACE_RESULT, FileFilters.FILE_FILTER_BATCH, FileFilters.FILE_FILTER_BATCH_RESULT);
        this.FILECHOOSER.setAcceptAllFileFilterUsed(false);
        this.FILECHOOSER.setMultiSelectionEnabled(true);
        this.FILECHOOSER.setDialogTitle("Open Workspace");
        this.FILECHOOSER.setFileFilter(FileFilters.FILE_FILTER_WORKSPACE);
        this.selectionMade = this.FILECHOOSER.showOpenDialog(owner) == 0;
        return this;
    }

    public FileDialogHelper addVector(Component owner) {
        this.setFileFilters(new FileFilter[0]);
        this.FILECHOOSER.setMultiSelectionEnabled(true);
        this.FILECHOOSER.setDialogTitle("Select vector(s) to load");
        this.selectionMade = this.FILECHOOSER.showOpenDialog(owner) == 0;
        return this;
    }

    public FileDialogHelper importLibrary(Component owner) {
        this.setFileFilters(FileFilters.FILE_FILTER_LIBRARY);
        this.FILECHOOSER.setMultiSelectionEnabled(false);
        this.FILECHOOSER.setDialogTitle("Import library");
        this.selectionMade = this.FILECHOOSER.showOpenDialog(owner) == 0;
        return this;
    }

    public FileDialogHelper exportLibrary(Component owner) {
        this.setFileFilters(FileFilters.FILE_FILTER_LIBRARY);
        this.FILECHOOSER.setMultiSelectionEnabled(false);
        this.FILECHOOSER.setDialogTitle("Export library");
        this.selectionMade = this.FILECHOOSER.showSaveDialog(owner) == 0;
        return this;
    }

    public FileDialogHelper chooseJar(Component owner) {
        this.setFileFilters(FileFilters.FILE_FILTER_JAR);
        this.FILECHOOSER.setMultiSelectionEnabled(false);
        this.FILECHOOSER.setDialogTitle("Select plugin jar");
        this.selectionMade = this.FILECHOOSER.showOpenDialog(owner) == 0;
        return this;
    }

    public FileDialogHelper saveWorkspaceAs(Component owner, FileFilter filter) {
        this.FILECHOOSER.setAcceptAllFileFilterUsed(false);
        this.setFileFilters(filter);
        this.FILECHOOSER.setDialogTitle("Save Workspace As");
        this.selectionMade = this.FILECHOOSER.showSaveDialog(owner) == 0;
        return this;
    }

    public File getSelectedFile() {
        File file = this.FILECHOOSER.getSelectedFile();
        this.FILECHOOSER.setSelectedFile(new File(""));
        return file;
    }

    public File[] getSelectedFiles() {
        File[] selectedFiles = this.FILECHOOSER.getSelectedFiles();
        this.FILECHOOSER.setSelectedFiles(new File[]{new File("")});
        return selectedFiles;
    }

    public boolean selectionMade() {
        return this.selectionMade;
    }

    public int showSaveDialog() {
        return this.FILECHOOSER.showSaveDialog(MainWindow.getInstance());
    }

    public int showSaveDialog(String filename) {
        this.FILECHOOSER.setSelectedFile(new File(filename));
        return this.FILECHOOSER.showSaveDialog(MainWindow.getInstance());
    }
}

