/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.xy.XYSeries;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.presentation.Argument;

public class ExtendableXYSeries
extends XYSeries {
    private String type;
    private PointToArgumentMap argMap = new PointToArgumentMap();

    public ExtendableXYSeries(Comparable key) {
        super(key);
    }

    public ExtendableXYSeries() {
        super((Comparable)((Object)""));
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void add(double x, double y, Argument ... args) {
        this.addToMap(x, y, args);
    }

    public List<Argument> getArgsForPoint(Point2D point) {
        return this.argMap.get(point);
    }

    public List<Argument> getArgsForPoint(double x, double y) {
        return this.getArgsForPoint(new Point2D(x, y));
    }

    public List<Argument> getArgsForPoint(Number x, Number y) {
        return this.getArgsForPoint(x.doubleValue(), y.doubleValue());
    }

    private void addToMap(double x, double y, Argument ... args) {
        super.add(x, y);
        if (args != null && args.length > 0 && args[0] != null) {
            Point2D point = new Point2D(x, y);
            this.argMap.put(point, Arrays.asList(args));
        }
    }

    private class PointToArgumentMap {
        Map<Object, ArrayList<Argument>> map = new HashMap<Object, ArrayList<Argument>>();

        public void put(Object key, List<Argument> args) {
            if (!this.map.containsKey(key)) {
                ArrayList<Argument> list = new ArrayList<Argument>();
                list.addAll(args);
                this.map.put(key, list);
            } else {
                this.map.get(key).clear();
                this.map.get(key).addAll(args);
            }
        }

        public ArrayList<Argument> get(Object key) {
            return this.map.get(key);
        }
    }
}

