/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.types.Description;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.DiscreteFunction2Panel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class DialogLibraryMaskFunctionDefine
extends EscapeDialog {
    private JPanel idPanelContainer = new JPanel(new BorderLayout());
    private GenericPanelEditor<Description> idPanel;
    private DiscreteFunction2Panel userDefinitionPanel = new DiscreteFunction2Panel();
    private MaskFunction mask;
    private Description description;

    public DialogLibraryMaskFunctionDefine(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public MaskFunction getModel() {
        return this.mask;
    }

    public Description getDescription() {
        return this.description;
    }

    private void init() {
        this.setSize(new Dimension(700, 450));
        this.getContentPane().add((Component)this.idPanelContainer, "North");
        this.getContentPane().add((Component)this.userDefinitionPanel, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.registerHelp();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(DialogLibraryMaskFunctionDefine.this);
            }
        }, stroke, 2);
    }

    public boolean show(MaskFunction model, Description description, String windowtitle, double victimBandwidth, double frequencyOffset, boolean showACLR, double interfererBandwidth, String xUnit, String yUnit) {
        this.mask = model;
        this.idPanel = new GenericPanelEditor<Description>(MainWindow.getInstance(), Description.class, description);
        this.idPanelContainer.add(this.idPanel, "Center");
        this.userDefinitionPanel.setVictimCharacteristics(victimBandwidth, frequencyOffset, showACLR, interfererBandwidth);
        this.userDefinitionPanel.setFunctionable((MaskFunctionImpl)this.mask, xUnit, yUnit);
        this.setTitle(windowtitle);
        this.setAccept(false);
        this.setVisible(true);
        this.userDefinitionPanel.stopEditing();
        return this.isAccept();
    }

    public boolean show(MaskFunction model, Description description, String string, String xUnit, String yUnit) {
        return this.show(model, description, string, -1.0, -1.0, false, 0.0, xUnit, yUnit);
    }

    public void updateModel() {
        this.mask = this.userDefinitionPanel.getFunctionable();
        this.description = this.idPanel.getModel();
    }
}

