/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.HtmlPanel;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.resources.ImageLoader;
import org.seamcat.tabulardataio.FileFormat;
import org.seamcat.tabulardataio.TabularDataFactory;

public class DialogHelper {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public static boolean restoreLibrary(JFrame owner) {
        return JOptionPane.showConfirmDialog(owner, "Are you sure you want to restore original library?", "Restore Library", 2) == 0;
    }

    public static int closeDirtyBatch(String name) {
        return JOptionPane.showConfirmDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_BATCH_ON_EXIT"), name), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1);
    }

    public static int closeNoResults(String name) {
        return JOptionPane.showConfirmDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT"), name), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1);
    }

    public static int saveResultsWhenClosing(String name, long estimatedEventSize) {
        String megabyteSize = DialogHelper.megabyteSize(estimatedEventSize);
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_WITH_RESULTS"), name, megabyteSize), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1, null, new String[]{"Yes", "No", STRINGLIST.getString("CLOSE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"));
    }

    public static int saveBatchWhenClosing(JDialog owner) {
        return JOptionPane.showOptionDialog(owner, STRINGLIST.getString("SAVE_BATCH_ON_CLOSE"), STRINGLIST.getString("SAVE_BATCH_TITLE"), 1, 1, null, new String[]{"Yes", "No", "Cancel"}, "Yes");
    }

    public static int saveModified() {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), STRINGLIST.getString("SAVE_OR_SAVE_WITH_MODIFIED_RESULTS"), "Save workspace", 1, 1, null, new String[]{STRINGLIST.getString("SAVE_WORKSPACE_ORIGINAL"), STRINGLIST.getString("SAVE_WORKSPACE_NEW_SETTING"), STRINGLIST.getString("SAVE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"));
    }

    public static int closeModified() {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), STRINGLIST.getString("SAVE_OR_SAVE_WITH_MODIFIED_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1, null, new String[]{STRINGLIST.getString("SAVE_WORKSPACE_ORIGINAL"), STRINGLIST.getString("SAVE_WORKSPACE_NEW_SETTING"), "No", STRINGLIST.getString("CLOSE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"));
    }

    public static void simulationError(SimulationInvalidException e) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), e.getDescription() + "\n" + e.getOrigin().getMessage(), "Simulation Aborted", 0);
    }

    public static int closeCleanAndUnmodifiedBig(String name) {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_WITH_RESULTS_TOO_LARGE"), name), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1, null, new String[]{STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"), "No", STRINGLIST.getString("CLOSE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"));
    }

    public static int saveModifiedBig(String name) {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_LARGE_RESULTS_MODIFIED"), name), "Save workspace", 1, 1, null, new String[]{STRINGLIST.getString("SAVE_ORIGINAL_WITHOUT_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_NEW_SETTING"), STRINGLIST.getString("SAVE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_ORIGINAL_WITHOUT_RESULTS"));
    }

    public static int closeModifiedBig(String name) {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_LARGE_RESULTS_MODIFIED"), name), STRINGLIST.getString("SAVE_WORKSPACE_ON_EXIT_TITLE"), 1, 1, null, new String[]{STRINGLIST.getString("SAVE_ORIGINAL_WITHOUT_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_NEW_SETTING"), "No", STRINGLIST.getString("CLOSE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_ORIGINAL_WITHOUT_RESULTS"));
    }

    private static String megabyteSize(long sizeInBytes) {
        double megabyteSize = (double)sizeInBytes / 1024.0 / 1024.0;
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return formatter.format(megabyteSize);
    }

    public static int saveWorkspaceResults(String name, long estimatedEventSize) {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS_TITLE"), name, DialogHelper.megabyteSize(estimatedEventSize)), STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS_WINDOW_TITLE"), 1, 1, null, new String[]{STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_FILE_EXISTS_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS"));
    }

    public static int saveCleanAndUnmodifiedBig(String name) {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), String.format(STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS_TOO_LARGE_TITLE"), name), STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS_TOO_LARGE_WINDOW_TITLE"), 2, 1, null, new String[]{STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"), STRINGLIST.getString("SAVE_WORKSPACE_CANCEL")}, STRINGLIST.getString("SAVE_WORKSPACE_WITHOUT_RESULTS"));
    }

    public static int consistencyError(Component component, StringBuffer messages) {
        JLabel label = new JLabel(STRINGLIST.getString("CONSISTENCY_ERROR_PRE") + messages.toString() + STRINGLIST.getString("CONSISTENCY_ERROR_POST"));
        JScrollPane scrollPane = new JScrollPane(label);
        scrollPane.setPreferredSize(new Dimension(900, 500));
        return JOptionPane.showOptionDialog(component, scrollPane, STRINGLIST.getString("CONSISTENCY_ERROR_TITLE"), 0, 2, null, new String[]{STRINGLIST.getString("CONSISTENCY_YES_OPTION"), STRINGLIST.getString("CONSISTENCY_NO_OPTION")}, null);
    }

    public static void about() {
        String title = "About SEAMCAT";
        String version = STRINGLIST.getString("APPLICATION_TITLE");
        String message = "<html><br><center><strong>" + version + "</strong></center><br><p>The SEAMCAT project is an ongoing <a href=\"http://www.cept.org/ecc\">ECC</a> activity within working group spectrum <br>engineering (<a href=\"http://www.cept.org/ecc/groups/ecc/wg-se\">WGSE</a>).</p><p>The software is maintained by <a href=\"http://www.cept.org/eco\">ECO</a> and distributed free-of-charge.</p><p>SEAMCAT is a software tool based on the Monte-Carlo simulation method, which is <br>developed within the frame of European Conference of Postal <br>and Telecommunication administrations (<a href=\"http://www.cept.org/cept\">CEPT</a>). This tool permits statistical modelling <br>of different radio interference scenarios for performing sharing and compatibility <br>studies between radiocommunications systems (short range devices, GSM, UMTS, <br>LTE, etc ) in the same or adjacent frequency bands. <br></p></html>";
        JPanel about = new JPanel(new BorderLayout());
        about.setBorder(BorderFactory.createEtchedBorder());
        ImageIcon icon = new ImageIcon(ImageLoader.class.getResource("about_seamcat_logo.png"));
        JLabel image = new JLabel("", icon, 0);
        about.add((Component)image, "North");
        HtmlPanel panel = new HtmlPanel(message, "5px 5px 5px 5px");
        about.add((Component)panel, "Center");
        JOptionPane.showMessageDialog(MainWindow.getInstance(), about, title, -1);
    }

    public static void reportError() {
        String messageString = "<html>You can report bugs, propose enhancements or new <br>features by sending an e-mail to<br><a href=\"mailto:seamcat@eco.cept.org\">seamcat@eco.cept.org</a> using this <a href=\"https://cept.org/Documents/stg/40262/stg-1x-xyz_stg-template\">template</a>.<br><br>For bug reports, please describe the error and attach <br>relevant information (e.g. workspace files, <br>screen shots, system log file etc). <br><br>The System Log file can be found in the folder: <br>" + Model.seamcatHome + "/logfiles/.<br><br>Thank you for your cooperation.<br><br>The SEAMCAT Team.</html>";
        HtmlPanel messagePane = new HtmlPanel(messageString);
        JOptionPane.showMessageDialog(MainWindow.getInstance(), messagePane, "Reporting bugs", -1, SeamcatIcons.getImageIcon("SEAMCAT_ICON_BUG_ERROR", 0));
    }

    public static void consistencyOk(Component component) {
        JOptionPane.showMessageDialog(component, STRINGLIST.getString("CONSISTENCY_OK"), STRINGLIST.getString("CONSISTENCY_OK_TITLE"), 1);
    }

    public static void consistencyErrorPre(Component component, StringBuffer messages) {
        JLabel label = new JLabel(STRINGLIST.getString("CONSISTENCY_ERROR_PRE") + messages.toString());
        JScrollPane scrollPane = new JScrollPane(label);
        scrollPane.setPreferredSize(new Dimension(900, 500));
        JOptionPane.showMessageDialog(component, scrollPane, STRINGLIST.getString("CONSISTENCY_ERROR_TITLE"), 2);
    }

    public static String getSaveDoneString(File file) {
        StringBuilder str = new StringBuilder();
        String image = ImageLoader.class.getResource("save_successed_16x16.png").toString();
        str.append("<html>");
        str.append("<img src=\"").append(image).append("\"> ");
        str.append(String.format(STRINGLIST.getString("SAVE_WORKSPACE_DONE"), file.getAbsolutePath()));
        str.append(" </html>");
        return str.toString();
    }

    public static String getSaveDoneWithResultsString(File file) {
        StringBuilder str = new StringBuilder();
        String image = ImageLoader.class.getResource("save_successed_16x16.png").toString();
        str.append("<html>");
        str.append("<img src=\"").append(image).append("\"> ");
        str.append(String.format(STRINGLIST.getString("SAVE_WORKSPACE_WITH_RESULTS_DONE"), file.getAbsolutePath()));
        str.append(" </html>");
        return str.toString();
    }

    public static String saveFaildMessage(String path) {
        StringBuilder str = new StringBuilder();
        String image = ImageLoader.class.getResource("save_failed_16x16.png").toString();
        str.append("<html>");
        str.append("<img src=\"").append(image).append("\"> ");
        str.append(String.format(STRINGLIST.getString("SAVE_WORKSPACE_FAILED"), path));
        str.append(" </html>");
        return str.toString();
    }

    public static void openWorkspaceError() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), STRINGLIST.getString("OPEN_WORKSPACE_ERROR"), STRINGLIST.getString("OPEN_WORKSPACE_ERROR_TITLE"), 0);
    }

    public static void saveError() {
        String messageString = "<html>An error occurred while saving. <br><br>Please make sure that you have write permissions to <br>the file you are writing to and the disk is not full. <br><br>Remember that files can be saved wherever you want <br>by choosing 'Save as...'</html>";
        JOptionPane.showMessageDialog(MainWindow.getInstance(), messageString, "Save error", 0);
    }

    public static int simulationSettings() {
        return JOptionPane.showOptionDialog(MainWindow.getInstance(), STRINGLIST.getString("CONSISTENCY_CDMA_EVENTS"), STRINGLIST.getString("CONSISTENCY_CDMA_EVENTS_TITLE"), 1, 2, null, new Object[]{"Run simulation with current settings", "Simulate 100 events", "Cancel"}, "Simulate 100 events");
    }

    public static void invalidFile() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "Invalid file", "Error", 0);
    }

    public static boolean overrideInLibrary(Component parent, String reference) {
        return 0 == JOptionPane.showConfirmDialog(parent, String.format("'%s' already exists in the library. Do you want to override?", reference), "Library conflict", 0, 2);
    }

    public static void backwardMigrationNotSupported() {
        JOptionPane.showMessageDialog(null, "In order to open this workspace, please install the latest version\nof SEAMCAT available for download in www.seamcat.org", "SEAMCAT version too old", 0);
    }

    public static void cannotOverwriteError(String filename) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>It is only possible to write new files from plugins.<br>File '" + filename + "' already exists.</html>", "SEAMCAT Error", 0);
    }

    public static void fileExtensionNotRecognized(String filename) {
        StringBuilder sb = new StringBuilder();
        for (FileFormat format : TabularDataFactory.allFormats()) {
            sb.append(format.getExtension());
            sb.append(" ");
        }
        JOptionPane.showMessageDialog(null, "Unknown file extension.\nFile '" + filename + "' has an unknown extension to SEAMCAT\nSupported extensions are: " + sb.toString(), "SEAMCAT Error", 0);
    }

    public static void versionWarning() {
        JOptionPane.showMessageDialog(null, "You are running an older version of SEAMCAT. For plugins this means non backward compatible changes. Get the latest version of SEAMCAT go to the web page...", "SEAMCAT version warning!", 2);
    }

    public static void versionMessage() {
        JOptionPane.showMessageDialog(null, "A newer version of SEAMCAT is available. For plugins the changes backward compatible but the API has more features available than the current one. Get the latest version of SEAMCAT go to the web page...", "SEAMCAT version warning!", 1);
    }

    public static void generalSeamcatInitializationError(Exception e) {
        JOptionPane.showMessageDialog(null, "Initialization of SEAMCAT failed.", "Initialization of SEAMCAT failed", 0);
    }

    public static void generalSeamcatError(Throwable e) {
        DialogHelper.generalSeamcatError("An unexpected error occurred.\n\nDiagnostics information: \n" + e.getMessage());
    }

    public static void generalSeamcatError(String message) {
        DialogHelper.generalSeamcatError(message, "Error");
    }

    public static void generalSeamcatError(String message, String title) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), message, title, 0);
    }

    public static int closingAllWorkspacesBatch() {
        return JOptionPane.showConfirmDialog(MainWindow.getInstance(), "Opening batch dialog will close all open workspaces. Do you want to proceed?", "Closing all workspaces", 2, 1);
    }

    public static void importLibraryNameConflict(List<LibraryItem> duplicates) {
        StringBuilder sb = new StringBuilder();
        for (LibraryItem duplicate : duplicates) {
            sb.append("<li>").append(Model.getInstance().getLibrary().typeName(duplicate)).append(" imported as '").append(duplicate.description().name()).append("' already exists in library</li>");
        }
        sb.append("</ul>");
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Duplicate names in library import<br><br><ul>" + sb.toString() + "</html>", "Duplicate names for Import", 0);
    }

    public static void cannotDeleteUsedSystem(String name) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>System '" + name + "' is used by the scenario and cannot be deleted</html>", "Unable to delete system", 0);
    }

    public static void interferenceCriteriaError() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Interference criteria can only be calculated when 'Noise Floor' is a constant distribution</html>", "Cannot tune interference criteria", 0);
    }

    public static void illegalCriteriaSelection() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Illegal selection of Interference criteria. Please select a valid row</html>", "Selection error", 0);
    }

    public static void gainCalculationError(Exception e) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Error calculating the antenna gain plot: " + e.getMessage() + "</html>", "Gain Evaluation Error", 0);
    }

    public static void noInputSelection() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Please select at least one signal type to perform calculation</html>", "Invalid input", 0);
    }

    public static void noIntermodVectorFound() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>Your scenario has not calculated the intermodulation vector.<br>You need at least two interference links for it to be calculated.</html>", "Invalid input", 0);
    }

    public static void noValidRange() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>For translation mode the translation parameters must be valid,<br>i.e. min < max and '# point' in the range 2 to 1000</html>", "Invalid input", 0);
    }

    public static void replayEventError(int max, int eventNumber) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>It is not possible to replay event " + eventNumber + ", which is outside the defined range by the scenario.<br>Please select an event in the range [0; " + max + "].</html>", "Event Number out of range", 0);
    }

    public static void mustSumTo100(double sum) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>The frequency scheduling must sum to 100% (current sum : " + sum + ")</html>", "Invalid input", 0);
    }

    public static void simulationAborted(String message) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), message, "Simulation Not Started", 0);
    }

    public static void noBatchesToRun() {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>No workspaces to run. Create or import workspaces into the batch before running.</html>", "Batch job empty", 0);
    }
}

