/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.SelectionMadeEvent;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.FunctionType;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.presentation.ConstantPanel;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.SelectionPanel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.components.UserDefinedFunctionPanel;

public class DialogFunctionDefine
extends EscapeDialog {
    private static final ResourceBundle stringlist = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private SelectionPanel selectionPanel = new SelectionPanel(this, stringlist.getString("FUNCTION_CONSTANT"), stringlist.getString("FUNCTION_USERDEFINED"));
    private JPanel detailPanel = new JPanel(new BorderLayout());
    private ConstantPanel constantFunctionPanel = new ConstantPanel();
    private final UserDefinedFunctionPanel userDefinitionPanel;

    public DialogFunctionDefine(Frame parent, Function function, final FunctionType functionType, String xAxis, String yAxis) {
        super(parent, true);
        this.userDefinitionPanel = new UserDefinedFunctionPanel(function, functionType, xAxis, yAxis);
        this.setSize(new Dimension(700, 450));
        this.detailPanel.add((Component)this.constantFunctionPanel, "Center");
        final Bounds[] bounds = new Bounds[1];
        if (functionType.isNone()) {
            this.getContentPane().add((Component)this.selectionPanel, "West");
        }
        this.getContentPane().add((Component)this.detailPanel, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this){

            @Override
            public void btnOkActionPerformed() {
                if (!functionType.isNone()) {
                    if (DialogFunctionDefine.this.userDefinitionPanel.getDiscreteFunction().points().size() == 0) {
                        JOptionPane.showMessageDialog(DialogFunctionDefine.this, "The function needs to have at least one point. Click cancel to exit this function dialog without making changes.", "Error", 0);
                    } else {
                        bounds[0] = DialogFunctionDefine.this.userDefinitionPanel.getDiscreteFunction().getBounds();
                        double min = 0.0;
                        double max = 0.0;
                        if (functionType.isHorizontal()) {
                            min = 0.0;
                            max = 360.0;
                        }
                        if (functionType.isVertical()) {
                            min = -90.0;
                            max = 90.0;
                        }
                        if (functionType.isSpherical()) {
                            min = 0.0;
                            max = 180.0;
                        }
                        if (min == bounds[0].getMin() && max == bounds[0].getMax()) {
                            DialogFunctionDefine.this.setAccept(true);
                            DialogFunctionDefine.this.setVisible(false);
                        } else {
                            JOptionPane.showMessageDialog(DialogFunctionDefine.this, "Range is not complete.\nRange should be [" + min + " to " + max + "]", "Range error", 0);
                        }
                    }
                } else {
                    DialogFunctionDefine.this.setAccept(true);
                    DialogFunctionDefine.this.setVisible(false);
                }
            }
        }, "South");
        this.registerHelp();
        this.setLocationRelativeTo(parent);
        EventBusFactory.getEventBus().subscribe(this);
    }

    public void destroy() {
        EventBusFactory.getEventBus().unsubscribe(this);
    }

    @UIEventHandler
    public void handle(SelectionMadeEvent event) {
        if (event.getContext() == this) {
            this.updateEditPanel(event.getName());
        }
    }

    private void updateEditPanel(String selected) {
        this.detailPanel.removeAll();
        if (selected.equals(stringlist.getString("FUNCTION_CONSTANT"))) {
            this.detailPanel.add((Component)this.constantFunctionPanel, "Center");
        } else {
            this.detailPanel.add((Component)this.userDefinitionPanel, "Center");
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    public DiscreteFunction getFunction() {
        if (this.selectionPanel.getSelection().equals(stringlist.getString("FUNCTION_CONSTANT"))) {
            return new DiscreteFunction(this.constantFunctionPanel.getConstant());
        }
        return this.userDefinitionPanel.getDiscreteFunction();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(DialogFunctionDefine.this);
            }
        }, stroke, 2);
    }

    private void setFunction(Function f) {
        if (f.isConstant()) {
            this.constantFunctionPanel.setConstant(f.getConstant());
            this.selectionPanel.setSelection(stringlist.getString("FUNCTION_CONSTANT"));
        } else if (f instanceof DiscreteFunction) {
            this.userDefinitionPanel.setDiscreteFunction((DiscreteFunction)f);
            this.selectionPanel.setSelection(stringlist.getString("FUNCTION_USERDEFINED"));
        }
        this.updateEditPanel(this.selectionPanel.getSelection());
    }

    public boolean show(Function function, String windowtitle) {
        this.setFunction(function);
        this.setTitle(windowtitle);
        this.setAccept(false);
        super.setVisible(true);
        this.userDefinitionPanel.stopEditing();
        return this.isAccept();
    }
}

