/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.XYDataset;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.components.DiscreteFunction2TableModelAdapter;

public class AclrDatasetWrapper
extends DiscreteFunction2TableModelAdapter
implements IntervalXYDataset,
XYItemLabelGenerator {
    public static final double DEFAULT_ADJACENT_CHANNEL = 1.0;
    protected int numberOfChannels;
    private double min;
    private double max;
    private IntervalXYDelegate delegate;
    private double interfererBandwidth = 1.25;
    private double adjacentChannel = 1.0;
    private final List<Channel> channels = new LinkedList<Channel>();

    public AclrDatasetWrapper(DiscreteFunction2TableModelAdapter origData) {
        super(origData.getFunction());
        this.delegate = new IntervalXYDelegate(this, false);
    }

    protected void update() {
        this.setDiscreteFunction2((MaskFunctionImpl)this.getFunction().normalize());
        this.min = this.getFunction().getBounds().getMin();
        this.max = this.getFunction().getBounds().getMax();
        double p0 = Mathematics.linear2dB(Mathematics.dB2Linear(this.function.integrate(0.0, this.interfererBandwidth)) * this.interfererBandwidth);
        double halfIBw = this.interfererBandwidth / 2.0;
        this.channels.clear();
        try {
            if (this.adjacentChannel == 0.0) {
                throw new IllegalArgumentException("AdjacentChannel is zero");
            }
            if (this.adjacentChannel > 0.0) {
                double numberOfChannelsD = (this.max - this.adjacentChannel) / this.interfererBandwidth;
                this.numberOfChannels = (int)numberOfChannelsD;
                int channelno = 1;
                double x = this.adjacentChannel + halfIBw;
                while (x <= this.max) {
                    this.addChannel(channelno, p0, x);
                    x += this.interfererBandwidth;
                    ++channelno;
                }
            } else {
                this.numberOfChannels = (int)(Math.abs(this.min - this.adjacentChannel) / this.interfererBandwidth);
                int channelno = 1;
                double x = this.adjacentChannel - halfIBw;
                while (x >= this.min) {
                    this.addChannel(channelno, p0, x);
                    x -= this.interfererBandwidth;
                    ++channelno;
                }
            }
        }
        catch (FunctionException ex) {
            throw new IllegalStateException("Trying to integrate x outside function bounds");
        }
    }

    private void addChannel(int channelno, double p0, double x) throws FunctionException {
        double y = p0 - Mathematics.linear2dB(Mathematics.dB2Linear(this.function.integrate(x, this.interfererBandwidth)) * this.interfererBandwidth);
        this.channels.add(new Channel(channelno, x, y));
    }

    @Override
    public int getItemCount(int series) {
        return this.numberOfChannels;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public Comparable getSeriesKey(int arg0) {
        return "ACLR";
    }

    private Channel getChannel(int channelno) {
        return this.channels.get(channelno);
    }

    private boolean hasChannel(int channelno) {
        return channelno < this.channels.size();
    }

    @Override
    public double getXValue(int series, int item) {
        return this.hasChannel(item) ? this.getChannel((int)item).x : 0.0;
    }

    @Override
    public double getYValue(int series, int item) {
        return this.hasChannel(item) ? this.getChannel((int)item).y : 0.0;
    }

    @Override
    public Number getEndX(int series, int item) {
        return this.delegate.getEndX(series, item);
    }

    @Override
    public double getEndXValue(int series, int item) {
        try {
            return this.delegate.getEndXValue(series, item);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public double getEndYValue(int series, int item) {
        try {
            return this.getYValue(series, item);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Number getStartX(int series, int item) {
        return this.delegate.getStartX(series, item);
    }

    @Override
    public double getStartXValue(int series, int item) {
        return this.delegate.getStartXValue(series, item);
    }

    @Override
    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    @Override
    public double getStartYValue(int series, int item) {
        try {
            return this.getYValue(series, item);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public String generateLabel(XYDataset dataset, int series, int item) {
        Channel c = this.getChannel(item);
        return String.format("%d. Adjacent Channel (%10.3f dB)", c.channelNo, Mathematics.round(c.y));
    }

    public void setInterfererBandwidth(double valueInMHz) {
        this.interfererBandwidth = valueInMHz;
        this.delegate.setFixedIntervalWidth(this.interfererBandwidth);
        this.update();
    }

    public void setAdjacentChannel(double valueInMHz) {
        this.adjacentChannel = valueInMHz;
        this.update();
    }

    private static class Channel {
        public final int channelNo;
        public final double x;
        public final double y;

        private Channel(int channelNo, double x, double y) {
            this.channelNo = channelNo;
            this.x = x;
            this.y = y;
        }
    }
}

