/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.propagation.PCLUTTER;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LocalEnvironmentResult;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.Locker;
import org.seamcat.plugin.PluginCheckUtil;

public class PropagationModelConfiguration<T>
extends MutableLibraryItem
implements PropagationModel<T> {
    private final Configuration<PropagationModelPlugin<T>, T> configuration;
    private boolean variationSelected;
    private String notes;

    PropagationModelConfiguration(Configuration<PropagationModelPlugin<T>, T> configuration) {
        this.configuration = configuration;
        this.variationSelected = configuration.optionalProperty("variations", true);
        this.setDescription(configuration.description());
        this.notes = "";
    }

    public PropagationModelConfiguration<T> copy() {
        return (PropagationModelConfiguration)Factory.propagationModelFactory().getByClass(this.getPluginClass(), this.getModel(), this.variationSelected, this.description().name(), this.notes);
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variation) {
        double clutter = 0.0;
        LocalEnvironmentResult rxEnv = linkResult.rxAntenna().getLocalEnvironment();
        LocalEnvironmentResult txEnv = linkResult.txAntenna().getLocalEnvironment();
        if (rxEnv.getEnvironment() == LocalEnvironment.Environment.Outdoor && rxEnv.isUsingClutter()) {
            clutter += this.calculateClutterLoss(linkResult.getFrequency(), linkResult.rxAntenna().getHeight(), linkResult.getTxRxDistance(), linkResult.rxAntenna().getElevation(), rxEnv);
        }
        if (!(txEnv.getEnvironment() != LocalEnvironment.Environment.Outdoor || !txEnv.isUsingClutter() || rxEnv.getEnvironment() == LocalEnvironment.Environment.Outdoor && rxEnv.isUsingClutter() && rxEnv.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.GENERAL && linkResult.getTxRxDistance() < 1.0 && txEnv.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.GENERAL)) {
            clutter += this.calculateClutterLoss(linkResult.getFrequency(), linkResult.txAntenna().getHeight(), linkResult.getTxRxDistance(), linkResult.txAntenna().getElevation(), txEnv);
        }
        linkResult.trialTxRxInSameBuilding();
        Locker locker = new Locker(linkResult);
        try {
            double d = clutter + this.getPlugin().evaluate(linkResult, variation, this.getModel());
            return d;
        }
        catch (RuntimeException e) {
            throw new SimulationInvalidException("Propagation model " + this.getPlugin().description().name() + " failed.", e);
        }
        finally {
            locker.unlock();
        }
    }

    private double calculateClutterLoss(double frequencyMHZ, double height, double txRxDistance, double elevationAngle, LocalEnvironmentResult le) {
        double clutter = 0.0;
        if (le.isUsingClutter()) {
            double frequency = frequencyMHZ / 1000.0;
            PCLUTTER pclutter = new PCLUTTER();
            if (le.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.SPECIFIC) {
                double R = le.getLocalClutter().R();
                int eqnum = le.getLocalClutter().eqnum();
                double ws = 0.0;
                if (le.isUserDefined()) {
                    R = le.getHeight();
                    ws = le.getWidth();
                }
                clutter = pclutter.cl_loss1(frequency, height, eqnum, R, ws);
            } else if (le.getOutdoorModel() == LocalEnvironment.OutdoorClutterMode.GENERAL) {
                double p = le.getPercentageOfLocations().trial();
                clutter = pclutter.cl_loss2(frequency, txRxDistance, p);
            } else {
                double p = le.getPercentageOfLocations().trial();
                clutter = pclutter.cl_loss3(frequency, elevationAngle, p);
            }
        }
        return clutter;
    }

    @Override
    public double evaluate(LinkResult linkResult) {
        return this.evaluate(linkResult, this.isVariationSelected());
    }

    @Override
    public boolean isVariationSelected() {
        return this.variationSelected;
    }

    public PropagationModelConfiguration<T> setVariationSelected(boolean variationSelected) {
        this.variationSelected = variationSelected;
        return this;
    }

    @Override
    public PropagationModelPlugin<T> getPlugin() {
        return this.configuration.getPlugin();
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public T getModel() {
        return this.configuration.getModel();
    }

    @Override
    public Class<T> getModelClass() {
        return this.configuration.getModelClass();
    }

    @Override
    public Class<? extends PropagationModelPlugin<T>> getPluginClass() {
        return this.configuration.getPluginClass();
    }

    @Override
    public ValidationResult consistencyCheck(ConsistencyCheckContext context) {
        return PluginCheckUtil.check(context, this.getPlugin(), this.getModel());
    }

    @Override
    public <T1> T1 optionalProperty(String name, T1 defaultValue) {
        throw new UnsupportedOperationException();
    }
}

