/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.plugin.PluginCheckUtil;

public class CoverageRadiusConfiguration<T>
extends MutableLibraryItem
implements CoverageRadius<T> {
    private final Configuration<CoverageRadiusPlugin<T>, T> configuration;
    private String notes;

    CoverageRadiusConfiguration(Configuration<CoverageRadiusPlugin<T>, T> configuration) {
        this.configuration = configuration;
        this.setDescription(configuration.description());
        this.notes = "";
    }

    public CoverageRadiusConfiguration<T> copy() {
        return (CoverageRadiusConfiguration)Factory.coverageRadii().getByClass(this.getPluginClass(), this.getModel(), this.description().name(), this.notes);
    }

    @Override
    public double evaluate(SystemPlugin plugin, RadioSystem system) {
        try {
            return this.getPlugin().evaluate(plugin, system, this.getModel());
        }
        catch (RuntimeException e) {
            throw new SimulationInvalidException("Coverage Radius Plugin " + this.getPlugin().description().name() + " failed.", e);
        }
    }

    @Override
    public CoverageRadiusPlugin<T> getPlugin() {
        return this.configuration.getPlugin();
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public T getModel() {
        return this.configuration.getModel();
    }

    @Override
    public Class<T> getModelClass() {
        return this.configuration.getModelClass();
    }

    @Override
    public Class<? extends CoverageRadiusPlugin<T>> getPluginClass() {
        return this.configuration.getPluginClass();
    }

    @Override
    public ValidationResult consistencyCheck(ConsistencyCheckContext context) {
        return PluginCheckUtil.check(context, this.getPlugin(), this.getModel());
    }

    @Override
    public <T1> T1 optionalProperty(String name, T1 defaultValue) {
        throw new UnsupportedOperationException();
    }
}

