/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import java.util.LinkedList;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnMarshallerW3CDom
implements UnMarshaller {
    private LinkedList<Element> elements = new LinkedList();

    public UnMarshallerW3CDom(Element root) {
        this.elements.add(root);
    }

    @Override
    public void checkBeginElement(String name) {
        Element container = this.elements.getLast();
        NodeList nodes = container.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!item.getNodeName().equals(name)) continue;
            this.elements.add((Element)item);
            return;
        }
        throw new RuntimeException("Expected element '" + name + "' not found");
    }

    private Element skipUntilNextElement(Node current) {
        if (current == null) {
            return null;
        }
        NodeList nodes = current.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!(item instanceof Element)) continue;
            return (Element)item;
        }
        return this.skipUntilNextElement(current.getNextSibling());
    }

    @Override
    public String attribute(String name) {
        return this.elements.getLast().getAttribute(name);
    }

    @Override
    public void checkEndElement(String name) {
        Element last = this.elements.getLast();
        if (last != null && last.getNodeName().equals(name)) {
            this.elements.removeLast();
        }
    }

    @Override
    public void processSequence(String name, Processor processor) {
        Element last = this.elements.getLast();
        NodeList list = last.getElementsByTagName(name);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            this.elements.add((Element)item);
            processor.process();
            this.elements.removeLast();
        }
    }

    @Override
    public void processOptionalElement(String name, Processor processor) {
        this.processSequence(name, processor);
    }

    @Override
    public void processOptionalWrappedElementSequence(String containerName, String childName, Processor processor) {
        if (this.peekNextElement(containerName)) {
            this.checkBeginElement(containerName);
            this.processSequence(childName, processor);
            this.checkEndElement(containerName);
        }
    }

    @Override
    public void processWrappedElementSequence(String containerName, String childName, Processor processor) {
        this.processOptionalWrappedElementSequence(containerName, childName, processor);
    }

    @Override
    public void consumeUntilEndElement(String name) {
    }

    @Override
    public boolean peekNextElement(String name) {
        Element container = this.elements.getLast();
        NodeList nodes = container.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }
}

