/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import org.apache.log4j.Logger;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PluginClass;

public class PluginMarshaller {
    private static final Logger LOG = Logger.getLogger(PluginMarshaller.class);

    public static void marshall(Marshaller marshaller, Configuration configuration, boolean inList) {
        String id;
        if (!inList) {
            marshaller.beginElement("pluginConfiguration");
        }
        marshaller.attribute("classname", configuration.getPlugin().getClass().getName());
        marshaller.attribute("location", JarFiles.getJarId(configuration));
        marshaller.attribute("name", configuration.description().name());
        marshaller.attribute("description", configuration.getNotes());
        if (configuration instanceof PropagationModel) {
            boolean selected = ((PropagationModel)configuration).isVariationSelected();
            marshaller.attribute("variation", Boolean.toString(selected));
        } else if (configuration instanceof AntennaGain) {
            double peakGain = ((AntennaGain)configuration).peakGain();
            marshaller.attribute("peakGain", Double.toString(peakGain));
        } else if (configuration instanceof EventProcessing && (id = ((EventProcessing)configuration).getId()) != null) {
            marshaller.attribute("id", id);
        }
        GenericTypeMarshaller.toElement(configuration.getModelClass(), marshaller, configuration.getModel());
        if (!inList) {
            marshaller.endElement("pluginConfiguration");
        }
    }

    public static Configuration unMarshallPlugin(UnMarshaller unMarshaller) {
        return PluginMarshaller.unMarshallPlugin(unMarshaller, false);
    }

    public static Configuration unMarshallPlugin(UnMarshaller unMarshaller, boolean inList) {
        Configuration configuration;
        if (!inList) {
            unMarshaller.checkBeginElement("pluginConfiguration");
        }
        String classname = unMarshaller.attribute("classname");
        String location = unMarshaller.attribute("location");
        String variation = unMarshaller.attribute("variation");
        String peakGain = unMarshaller.attribute("peakGain");
        String name = unMarshaller.attribute("name");
        String notes = unMarshaller.attribute("description");
        String id = unMarshaller.attribute("id");
        JarConfigurationModel jar = JarFiles.getJarConfiguration(location);
        if (jar == null) {
            unMarshaller.consumeUntilEndElement("pluginConfiguration");
            if (!inList) {
                unMarshaller.checkEndElement("pluginConfiguration");
            }
            return null;
        }
        PluginClass pc = jar.getPluginClass(classname);
        if (pc == null) {
            LOG.warn(classname + ": could not be loaded. Skipping.");
            return null;
        }
        Class<?> modelClass = pc.getModelClass();
        Object model = GenericTypeMarshaller.fromElement(modelClass, unMarshaller);
        Class<? extends Plugin<?>> pluginClass = pc.getPluginClass();
        if (PropagationModelPlugin.class.isAssignableFrom(pluginClass)) {
            configuration = Factory.propagationModelFactory().getByClass(pluginClass, model, Boolean.valueOf(variation), name, notes);
        } else if (AntennaGainPlugin.class.isAssignableFrom(pluginClass)) {
            configuration = Factory.antennaGainFactory().getByClass(pluginClass, model, Double.parseDouble(peakGain), name, notes);
        } else if (EventProcessingPlugin.class.isAssignableFrom(pluginClass)) {
            configuration = Factory.eventProcessors().getByClass(pluginClass, model, id, name, notes);
        } else if (CoverageRadiusPlugin.class.isAssignableFrom(pluginClass)) {
            configuration = Factory.coverageRadii().getByClass(pluginClass, model, name, notes);
        } else {
            throw new RuntimeException("Unknown plugin");
        }
        if (!inList) {
            unMarshaller.checkEndElement("pluginConfiguration");
        }
        return configuration;
    }

    public static void marshall(JarConfigurationModel model, Marshaller marshaller, boolean inList) {
        if (!inList) {
            marshaller.beginElement("jar");
        }
        marshaller.attribute("name", model.description().name());
        marshaller.attribute("data", model.getJarData());
        if (!inList) {
            marshaller.endElement("jar");
        }
    }

    public static JarConfigurationModel fromElement(UnMarshaller unMarshaller) {
        return new JarConfigurationModel(unMarshaller.attribute("data"), unMarshaller.attribute("name"));
    }
}

