/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.impl.XmlEventFactory;

public class MarshallerStream
implements Marshaller {
    private XMLEventWriter eventWriter;

    public MarshallerStream(XMLEventWriter eventWriter) {
        this.eventWriter = eventWriter;
        try {
            eventWriter.add(XmlEventFactory.startDocument());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginElement(String name) {
        try {
            this.eventWriter.add(XmlEventFactory.startElement(name));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void attribute(String name, String value) {
        if (value == null) {
            return;
        }
        try {
            this.eventWriter.add(XmlEventFactory.attribute(name, value));
        }
        catch (XMLStreamException e) {
            System.out.println("name = " + name + ",  value = " + value);
            e.printStackTrace();
        }
    }

    @Override
    public void endElement(String name) {
        try {
            this.eventWriter.add(XmlEventFactory.endElement(name));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.eventWriter.add(XmlEventFactory.endDocument());
            this.eventWriter.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

