/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.UnMarshaller;

public class LinkResultMarshaller {
    public static final UniqueValueDef EVENT_NUMBER = Factory.results().single("Event Number", "");

    public static void marshall(Marshaller marshaller, LinkResult link) {
        marshaller.beginElement("linkResult");
        marshaller.attribute("pathloss", LinkResultMarshaller.round(link.getTxRxPathLoss()));
        marshaller.attribute("power", LinkResultMarshaller.round(link.getTxPower()));
        marshaller.attribute("frequency", LinkResultMarshaller.round(link.getFrequency()));
        LinkResultMarshaller.marshall(marshaller, "rx", link.rxAntenna());
        LinkResultMarshaller.marshall(marshaller, "tx", link.txAntenna());
        if (link.hasValue(EVENT_NUMBER)) {
            marshaller.attribute("eventNumber", Integer.toString((Integer)link.getValue(EVENT_NUMBER)));
        }
        marshaller.endElement("linkResult");
    }

    private static String round(double value) {
        return Double.toString((double)Math.round(value * 1000.0) / 1000.0);
    }

    private static void marshall(Marshaller marshaller, String prefix, AntennaResult ar) {
        marshaller.attribute(prefix + "_gain", LinkResultMarshaller.round(ar.getGain()));
        marshaller.attribute(prefix + "_azimuth", LinkResultMarshaller.round(ar.getAzimuth()));
        marshaller.attribute(prefix + "_elevation", LinkResultMarshaller.round(ar.getElevation()));
        marshaller.attribute(prefix + "_height", LinkResultMarshaller.round(ar.getHeight()));
        marshaller.attribute(prefix + "_x", LinkResultMarshaller.round(ar.getPosition().getX()));
        marshaller.attribute(prefix + "_y", LinkResultMarshaller.round(ar.getPosition().getY()));
    }

    public static LinkResult unMarshall(UnMarshaller unMarshaller) {
        LinkResult result = Factory.results().linkResult();
        result.setTxRxPathLoss(Double.parseDouble(unMarshaller.attribute("pathloss")));
        result.setTxPower(Double.parseDouble(unMarshaller.attribute("power")));
        result.setFrequency(Double.parseDouble(unMarshaller.attribute("frequency")));
        LinkResultMarshaller.unMarshall(unMarshaller, "tx", result.txAntenna());
        LinkResultMarshaller.unMarshall(unMarshaller, "rx", result.rxAntenna());
        String number = unMarshaller.attribute("eventNumber");
        if (number != null && !number.isEmpty()) {
            result.setValue(EVENT_NUMBER, Integer.parseInt(number));
        }
        return result;
    }

    private static void unMarshall(UnMarshaller unMarshaller, String prefix, AntennaResult a) {
        a.setGain(Double.parseDouble(unMarshaller.attribute(prefix + "_gain")));
        a.setAzimuth(Double.parseDouble(unMarshaller.attribute(prefix + "_azimuth")));
        a.setElevation(Double.parseDouble(unMarshaller.attribute(prefix + "_elevation")));
        a.setHeight(Double.parseDouble(unMarshaller.attribute(prefix + "_height")));
        a.setPosition(new Point2D(Double.parseDouble(unMarshaller.attribute(prefix + "_x")), Double.parseDouble(unMarshaller.attribute(prefix + "_y"))));
    }
}

