/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.LibraryFunctionItem;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.plugin.CalculatedValue;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.ExtendableEnum;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.model.types.result.VectorResult;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.DistributionMarshaller;
import org.seamcat.persistence.impl.FunctionMarshaller;
import org.seamcat.persistence.impl.PluginMarshaller;
import org.seamcat.persistence.impl.UnmarshallingException;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;

public class GenericTypeMarshaller {
    private static final Logger LOG = Logger.getLogger(GenericTypeMarshaller.class);
    private static Set<Class> recursionClasses = new HashSet<Class>();

    public static <T> T fromElement(Class<T> clazz, UnMarshaller unMarshaller) {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        if (SystemModel.class.isAssignableFrom(clazz)) {
            try {
                values.put(SystemModel.class.getMethod("id", new Class[0]), unMarshaller.attribute("id"));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        for (Method m : GenericTypeMarshaller.marshallOrder(clazz)) {
            values.put(m, GenericTypeMarshaller.unmarshall(unMarshaller, m, GenericTypeMarshaller.defaultValue(clazz, m)));
        }
        return ProxyHelper.newInstance(clazz, values);
    }

    public static <T> void toElement(Class<T> clazz, Marshaller marshaller, T model) {
        if (model instanceof SystemModel) {
            try {
                String id = ((SystemModel)model).id();
                if (id == null) {
                    id = UUID.randomUUID().toString();
                }
                GenericTypeMarshaller.marshall(marshaller, SystemModel.class.getMethod("id", new Class[0]), id);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        for (Method method : GenericTypeMarshaller.marshallOrder(clazz)) {
            try {
                GenericTypeMarshaller.marshall(marshaller, method, method.invoke(model, new Object[0]));
            }
            catch (Exception e) {
                LOG.error("Marshalling error", e);
            }
        }
    }

    private static List<Method> marshallOrder(Class<?> clazz) {
        ArrayList<Method> marshallOrder = new ArrayList<Method>();
        TreeMap<Integer, Method> ordered = new TreeMap<Integer, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            UITab tab;
            UIPosition pos;
            Config config = method.getAnnotation(Config.class);
            if (config != null) {
                if (GenericTypeMarshaller.attributeType(method)) {
                    marshallOrder.add(method);
                } else {
                    ordered.put(config.order(), method);
                }
            }
            if ((pos = method.getAnnotation(UIPosition.class)) != null) {
                ordered.put(100 + (10 * pos.row() + pos.col()), method);
            }
            if ((tab = method.getAnnotation(UITab.class)) == null) continue;
            ordered.put(1000 + tab.order(), method);
        }
        for (Method method : ordered.values()) {
            marshallOrder.add(method);
        }
        return marshallOrder;
    }

    private static boolean attributeType(Method method) {
        Type type1;
        Type genericReturnType;
        Class<?> type = method.getReturnType();
        if (type.isPrimitive()) {
            return true;
        }
        if (Double.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (OptionalValue.class.isAssignableFrom(type) && (genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType && (type1 = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0]) instanceof Class) {
            Class clz = (Class)type1;
            if (Double.class.isAssignableFrom(clz)) {
                return true;
            }
            if (Integer.class.isAssignableFrom(clz)) {
                return true;
            }
        }
        return false;
    }

    private static void marshall(Marshaller marshaller, Method method, Object object) {
        String name = method.getName();
        if (!GenericTypeMarshaller.marshallPrimitive(marshaller, name, object, false) && !CalculatedValue.class.isAssignableFrom(method.getReturnType())) {
            if (Enum.class.isAssignableFrom(method.getReturnType())) {
                ?[] enumConstants = method.getReturnType().getEnumConstants();
                int index = 0;
                for (int i = 0; i < enumConstants.length; ++i) {
                    if (enumConstants[i] != object) continue;
                    index = i;
                }
                marshaller.attribute(name, Integer.toString(index));
            } else if (object instanceof List) {
                ParameterizedType paramType = (ParameterizedType)method.getGenericReturnType();
                Config config = method.getAnnotation(Config.class);
                Class elementClass = (Class)paramType.getActualTypeArguments()[0];
                marshaller.beginElement(name);
                List list = (List)object;
                String elementName = "item";
                if (!config.elementName().isEmpty()) {
                    elementName = config.elementName();
                }
                for (Object o : list) {
                    marshaller.beginElement(elementName);
                    if (!o.getClass().getInterfaces()[0].isAssignableFrom(elementClass) && !(o instanceof Configuration)) {
                        marshaller.attribute("class", elementClass.getName());
                    }
                    if (o instanceof EmissionMask || o instanceof LibraryFunctionItem || o instanceof Configuration || o instanceof JarConfigurationModel || o instanceof SystemPluginConfiguration || o instanceof Double || o instanceof Integer || o instanceof SystemPlugin) {
                        GenericTypeMarshaller.marshallPrimitive(marshaller, elementName, o, true);
                    } else {
                        GenericTypeMarshaller.toElement(elementClass, marshaller, o);
                    }
                    marshaller.endElement(elementName);
                }
                marshaller.endElement(name);
            } else {
                marshaller.beginElement(name);
                GenericTypeMarshaller.toElement(method.getReturnType(), marshaller, object);
                marshaller.endElement(name);
            }
        }
    }

    private static <T> Object unmarshall(final UnMarshaller unMarshaller, final Method method, Object defaultValue) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        try {
            Object value = GenericTypeMarshaller.unmarshallPrimitive(defaultValue, unMarshaller, name, type, method, false);
            if (value != null) {
                return value;
            }
            if (List.class.isAssignableFrom(type)) {
                Object o;
                ParameterizedType paramType = (ParameterizedType)method.getGenericReturnType();
                final Class elementClass = (Class)paramType.getActualTypeArguments()[0];
                unMarshaller.checkBeginElement(name);
                Config config = method.getAnnotation(Config.class);
                final String elementName = config.elementName().isEmpty() ? "item" : config.elementName();
                final ArrayList list = new ArrayList();
                unMarshaller.processSequence(elementName, new Processor(){

                    @Override
                    public void process() {
                        Class<?> recursionClass = elementClass;
                        String aClass = unMarshaller.attribute("class");
                        if (aClass != null && !aClass.isEmpty()) {
                            try {
                                recursionClass = Class.forName(aClass);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        if (recursionClasses.contains(recursionClass)) {
                            try {
                                Object o = GenericTypeMarshaller.unmarshallPrimitive(null, unMarshaller, elementName, recursionClass, method, true);
                                if (o != null) {
                                    list.add(o);
                                }
                            }
                            catch (RuntimeException runtimeException) {}
                        } else {
                            list.add(GenericTypeMarshaller.fromElement(recursionClass, unMarshaller));
                        }
                    }
                });
                ArrayList result = list;
                if (!result.isEmpty() && (o = result.get(0)) instanceof JarConfigurationModel) {
                    ArrayList<JarConfigurationModel> noDuplicates = new ArrayList<JarConfigurationModel>();
                    for (Object jar : result) {
                        if (noDuplicates.contains(jar)) continue;
                        noDuplicates.add((JarConfigurationModel)jar);
                    }
                    result = noDuplicates;
                }
                unMarshaller.checkEndElement(name);
                return result;
            }
            unMarshaller.checkBeginElement(name);
            Object o = GenericTypeMarshaller.recurse(type, unMarshaller, method);
            unMarshaller.checkEndElement(name);
            return o;
        }
        catch (UnmarshallingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    private static boolean marshallPrimitive(Marshaller marshaller, String name, Object object, boolean inList) {
        if (object instanceof Map) {
            Map map = (Map)object;
            marshaller.beginElement(name);
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof Class)) continue;
                Class clazz = (Class)entry.getKey();
                marshaller.beginElement("customItem");
                marshaller.attribute("classname", clazz.getName());
                GenericTypeMarshaller.toElement(clazz, marshaller, entry.getValue());
                marshaller.endElement("customItem");
            }
            marshaller.endElement(name);
            return true;
        }
        if (object instanceof Integer) {
            marshaller.attribute(name, String.valueOf(object));
            return true;
        }
        if (object instanceof Double) {
            marshaller.attribute(name, String.valueOf(object));
            return true;
        }
        if (object instanceof Boolean) {
            marshaller.attribute(name, Boolean.toString((Boolean)object));
            return true;
        }
        if (object instanceof Distribution) {
            marshaller.beginElement(name);
            DistributionMarshaller.marshall(marshaller, (Distribution)object);
            marshaller.endElement(name);
            return true;
        }
        if (object instanceof String) {
            marshaller.attribute(name, (String)object);
            return true;
        }
        if (object instanceof EmissionMask) {
            if (!inList) {
                marshaller.beginElement(name);
            }
            EmissionMask emissionMask = (EmissionMask)object;
            marshaller.attribute("reference", emissionMask.description().name());
            marshaller.attribute("description", emissionMask.description().description());
            FunctionMarshaller.marshall(marshaller, emissionMask.getEmissionMask());
            if (!inList) {
                marshaller.endElement(name);
            }
            return true;
        }
        if (object instanceof MaskFunction) {
            if (!inList) {
                marshaller.beginElement(name);
            }
            MaskFunction mask = (MaskFunction)object;
            FunctionMarshaller.marshall(marshaller, mask);
            if (!inList) {
                marshaller.endElement(name);
            }
            return true;
        }
        if (object instanceof BlockingMask) {
            FunctionMarshaller.marshall(marshaller, (BlockingMask)object, inList);
            return true;
        }
        if (object instanceof BitRateMapping) {
            if (!inList) {
                marshaller.beginElement(name);
            }
            BitRateMapping bitRateMapping = (BitRateMapping)object;
            marshaller.attribute("name", bitRateMapping.description().name());
            marshaller.attribute("description", bitRateMapping.description().description());
            FunctionMarshaller.marshall(marshaller, bitRateMapping.getFunction());
            if (!inList) {
                marshaller.endElement(name);
            }
            return true;
        }
        if (object instanceof IntermodulationRejectionMask) {
            if (!inList) {
                marshaller.beginElement(name);
            }
            FunctionMarshaller.marshall(marshaller, (IntermodulationRejectionMask)object);
            if (!inList) {
                marshaller.endElement(name);
            }
            return true;
        }
        if (object instanceof Function) {
            marshaller.beginElement(name);
            FunctionMarshaller.marshall(marshaller, (Function)object);
            marshaller.endElement(name);
            return true;
        }
        if (object instanceof Configuration) {
            if (!inList) {
                marshaller.beginElement(name);
            }
            PluginMarshaller.marshall(marshaller, (Configuration)object, inList);
            if (!inList) {
                marshaller.endElement(name);
            }
            return true;
        }
        if (object instanceof OptionalValue) {
            OptionalValue ov = (OptionalValue)object;
            Object value = ov.getValue();
            if (value instanceof MaskFunction) {
                marshaller.beginElement(name);
                marshaller.attribute("enabled", Boolean.toString(ov.isRelevant()));
                FunctionMarshaller.marshall(marshaller, (MaskFunction)value);
                marshaller.endElement(name);
                return true;
            }
            if (value instanceof Function) {
                marshaller.beginElement(name);
                marshaller.attribute("enabled", Boolean.toString(ov.isRelevant()));
                marshaller.beginElement("function");
                FunctionMarshaller.marshall(marshaller, (Function)value);
                marshaller.endElement("function");
                marshaller.endElement(name);
                return true;
            }
            if (value instanceof IntermodulationRejectionMask) {
                if (!inList) {
                    marshaller.beginElement(name);
                }
                marshaller.attribute("enabled", Boolean.toString(ov.isRelevant()));
                FunctionMarshaller.marshall(marshaller, (IntermodulationRejectionMask)value);
                if (!inList) {
                    marshaller.endElement(name);
                }
                return true;
            }
            if (value instanceof Double) {
                marshaller.attribute(name, String.valueOf(value));
                marshaller.attribute("use_" + name, Boolean.toString(ov.isRelevant()));
                return true;
            }
            if (value instanceof Integer) {
                marshaller.attribute(name, String.valueOf(value));
                marshaller.attribute("use_" + name, Boolean.toString(ov.isRelevant()));
                return true;
            }
            if (value instanceof Distribution) {
                marshaller.beginElement(name);
                marshaller.attribute("enabled", Boolean.toString(ov.isRelevant()));
                DistributionMarshaller.marshall(marshaller, (Distribution)value);
                marshaller.endElement(name);
                return true;
            }
        } else {
            if (object instanceof ExtendableEnum && object instanceof Enum) {
                ?[] enumConstants = object.getClass().getSuperclass().getEnumConstants();
                int index = 0;
                for (int i = 0; i < enumConstants.length; ++i) {
                    if (enumConstants[i] != object) continue;
                    index = i;
                    break;
                }
                String className = object.getClass().getSuperclass().getName();
                marshaller.attribute(name, className);
                marshaller.attribute(name + "_index", Integer.toString(index));
                return true;
            }
            if (object instanceof JarConfigurationModel) {
                PluginMarshaller.marshall((JarConfigurationModel)object, marshaller, inList);
                return true;
            }
            if (object instanceof SystemPluginConfiguration) {
                SystemPluginConfiguration configuration = (SystemPluginConfiguration)object;
                marshaller.attribute("classname", configuration.classname());
                marshaller.attribute("location", configuration.location());
                marshaller.beginElement("configuration");
                Class<? extends SystemPlugin> pluginClass = JarFiles.getJarConfiguration(configuration.location()).getSystemPluginClass(configuration.classname());
                try {
                    SystemPlugin systemPlugin = pluginClass.newInstance();
                    Class<? extends SystemModel> uiClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
                    GenericTypeMarshaller.toElement(uiClass, marshaller, configuration.configuration());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                marshaller.endElement("configuration");
            } else if (object instanceof SystemPlugin) {
                SystemPlugin plugin = (SystemPlugin)object;
                JarConfigurationModel jar = JarFiles.getJar(plugin);
                marshaller.attribute("classname", plugin.getClass().getName());
                marshaller.attribute("location", jar.getHash());
                marshaller.beginElement("configuration");
                Class<? extends SystemModel> uiClass = GenericTypeMarshaller.getPluginUIClass(plugin);
                GenericTypeMarshaller.toElement(uiClass, marshaller, plugin.getUI());
                marshaller.endElement("configuration");
            } else if (object instanceof VectorResultType) {
                VectorResultType vr = (VectorResultType)object;
                marshaller.beginElement(name);
                marshaller.attribute("name", vr.getName());
                marshaller.attribute("unit", vr.getUnit());
                GenericTypeMarshaller.writeVector(marshaller, vr.getValue());
                marshaller.endElement(name);
                return true;
            }
        }
        return false;
    }

    private static void writeVector(Marshaller marshaller, VectorResult vector) {
        marshaller.beginElement("values");
        for (double d : vector.asArray()) {
            marshaller.beginElement("value");
            marshaller.attribute("v", Double.toString(d));
            marshaller.endElement("value");
        }
        marshaller.endElement("values");
    }

    private static <T> Object unmarshallPrimitive(Object defaultValue, final UnMarshaller unMarshaller, String name, Class type, Method method, boolean inList) {
        if (Map.class.isAssignableFrom(type)) {
            final LinkedHashMap map = new LinkedHashMap();
            unMarshaller.processWrappedElementSequence(name, "customItem", new Processor(){

                @Override
                public void process() {
                    try {
                        Class<?> aClass = Class.forName(unMarshaller.attribute("classname"));
                        map.put(aClass, GenericTypeMarshaller.fromElement(aClass, unMarshaller));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
            return map;
        }
        if (type.isPrimitive()) {
            if (Double.TYPE.isAssignableFrom(type)) {
                return Double.parseDouble(unMarshaller.attribute(name));
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                String attribute = unMarshaller.attribute(name);
                if (attribute.isEmpty() && defaultValue != null) {
                    return defaultValue;
                }
                return Boolean.valueOf(attribute);
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return Integer.parseInt(unMarshaller.attribute(name));
            }
        }
        if (Double.class.isAssignableFrom(type)) {
            return Double.parseDouble(unMarshaller.attribute(name));
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(unMarshaller.attribute(name));
        }
        if (Distribution.class.isAssignableFrom(type)) {
            if (!unMarshaller.peekNextElement(name)) {
                if (defaultValue != null) {
                    return defaultValue;
                }
                return Factory.distributionFactory().getConstantDistribution(0.0);
            }
            unMarshaller.checkBeginElement(name);
            Distribution distribution = DistributionMarshaller.unMarshall(unMarshaller);
            unMarshaller.checkEndElement(name);
            return distribution;
        }
        if (String.class.isAssignableFrom(type)) {
            return unMarshaller.attribute(name);
        }
        if (EmissionMask.class.isAssignableFrom(type)) {
            String reference;
            if (!inList) {
                unMarshaller.checkBeginElement(name);
            }
            if ((reference = unMarshaller.attribute("reference")) == null || reference.isEmpty()) {
                reference = "Spectrum Emission Mask";
            }
            DescriptionImpl desc = new DescriptionImpl(reference, unMarshaller.attribute("description"));
            MaskFunction maskFunction = FunctionMarshaller.unMarshall(unMarshaller);
            if (!inList) {
                unMarshaller.checkEndElement(name);
            }
            return Factory.functionFactory().emissionMask(maskFunction, desc);
        }
        if (BlockingMask.class.isAssignableFrom(type)) {
            if (inList) {
                return FunctionMarshaller.unMarshallBlockingMask(unMarshaller);
            }
            unMarshaller.checkBeginElement(name);
            BlockingMask mask = FunctionMarshaller.unMarshallBlockingMask(unMarshaller);
            unMarshaller.checkEndElement(name);
            return mask;
        }
        if (BitRateMapping.class.isAssignableFrom(type)) {
            if (!inList) {
                unMarshaller.checkBeginElement(name);
            }
            DescriptionImpl desc = new DescriptionImpl(unMarshaller.attribute("name"), unMarshaller.attribute("description"));
            Function f = FunctionMarshaller.unMarshallFunction(unMarshaller);
            if (!inList) {
                unMarshaller.checkEndElement(name);
            }
            return Factory.functionFactory().bitRateMapping(f, desc);
        }
        if (IntermodulationRejectionMask.class.isAssignableFrom(type)) {
            String name1;
            if (!inList) {
                unMarshaller.checkBeginElement(name);
            }
            if ((name1 = unMarshaller.attribute("reference")) == null || name1.isEmpty()) {
                name1 = "Intermodulation Rejection Mask";
            }
            DescriptionImpl desc = new DescriptionImpl(name1, unMarshaller.attribute("description"));
            Function function = FunctionMarshaller.unMarshallFunction(unMarshaller);
            IntermodulationRejectionMask mask = Factory.functionFactory().intermodulationRejectMask(function, desc);
            if (!inList) {
                unMarshaller.checkEndElement(name);
            }
            return mask;
        }
        if (MaskFunction.class.isAssignableFrom(type)) {
            unMarshaller.checkBeginElement(name);
            MaskFunction maskFunction = FunctionMarshaller.unMarshall(unMarshaller);
            unMarshaller.checkEndElement(name);
            return maskFunction;
        }
        if (Function.class.isAssignableFrom(type)) {
            unMarshaller.checkBeginElement(name);
            Function function = FunctionMarshaller.unMarshallFunction(unMarshaller);
            unMarshaller.checkEndElement(name);
            return function;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return Integer.parseInt(unMarshaller.attribute(name));
        }
        if (PropagationModel.class.isAssignableFrom(type) || AntennaGain.class.isAssignableFrom(type) || CoverageRadius.class.isAssignableFrom(type)) {
            unMarshaller.checkBeginElement(name);
            Configuration configuration = PluginMarshaller.unMarshallPlugin(unMarshaller);
            unMarshaller.checkEndElement(name);
            return configuration;
        }
        if (OptionalValue.class.isAssignableFrom(type)) {
            Type tType;
            boolean isRelevant = false;
            Object value = null;
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType && (tType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0]) instanceof Class) {
                Class clazz = (Class)tType;
                if (clazz.isAssignableFrom(Function.class)) {
                    unMarshaller.checkBeginElement(name);
                    String enabled = unMarshaller.attribute("enabled");
                    if (enabled != null) {
                        isRelevant = Boolean.parseBoolean(enabled);
                    }
                    value = FunctionMarshaller.unMarshallFunction(unMarshaller);
                    unMarshaller.checkEndElement(name);
                } else if (clazz.isAssignableFrom(MaskFunction.class)) {
                    unMarshaller.checkBeginElement(name);
                    String enabled = unMarshaller.attribute("enabled");
                    if (enabled != null) {
                        isRelevant = Boolean.parseBoolean(enabled);
                    }
                    value = FunctionMarshaller.unMarshall(unMarshaller);
                    unMarshaller.checkEndElement(name);
                } else if (clazz.isAssignableFrom(Double.class)) {
                    isRelevant = Boolean.valueOf(unMarshaller.attribute("use_" + name));
                    value = Double.parseDouble(unMarshaller.attribute(name));
                } else if (clazz.isAssignableFrom(Integer.class)) {
                    value = Integer.parseInt(unMarshaller.attribute(name));
                    isRelevant = Boolean.valueOf(unMarshaller.attribute("use_" + name));
                } else if (clazz.isAssignableFrom(Distribution.class)) {
                    unMarshaller.checkBeginElement(name);
                    String enabled = unMarshaller.attribute("enabled");
                    if (enabled != null) {
                        isRelevant = Boolean.parseBoolean(enabled);
                    }
                    value = DistributionMarshaller.unMarshall(unMarshaller);
                    unMarshaller.checkEndElement(name);
                } else if (clazz.isAssignableFrom(IntermodulationRejectionMask.class)) {
                    String name1;
                    String enabled;
                    if (!inList) {
                        unMarshaller.checkBeginElement(name);
                    }
                    if ((enabled = unMarshaller.attribute("enabled")) != null) {
                        isRelevant = Boolean.parseBoolean(enabled);
                    }
                    if ((name1 = unMarshaller.attribute("reference")) == null || name1.isEmpty()) {
                        name1 = "Intermodulation Rejection Mask";
                    }
                    DescriptionImpl desc = new DescriptionImpl(name1, unMarshaller.attribute("description"));
                    Function function = FunctionMarshaller.unMarshallFunction(unMarshaller);
                    value = Factory.functionFactory().intermodulationRejectMask(function, desc);
                    if (!inList) {
                        unMarshaller.checkEndElement(name);
                    }
                }
            }
            return Factory.results().optional(isRelevant, value);
        }
        if (CalculatedValue.class.isAssignableFrom(type)) {
            return new CalculatedValue(null);
        }
        if (Enum.class.isAssignableFrom(type)) {
            int i = 0;
            try {
                i = Integer.parseInt(unMarshaller.attribute(name));
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
            return type.getEnumConstants()[i];
        }
        if (ExtendableEnum.class.isAssignableFrom(type)) {
            String className = unMarshaller.attribute(name);
            int index = Integer.parseInt(unMarshaller.attribute(name + "_index"));
            try {
                return Class.forName(className).getEnumConstants()[index];
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Error finding class: " + className);
            }
        }
        if (Configuration.class.isAssignableFrom(type)) {
            return PluginMarshaller.unMarshallPlugin(unMarshaller, true);
        }
        if (JarConfigurationModel.class.isAssignableFrom(type)) {
            JarConfigurationModel jar = PluginMarshaller.fromElement(unMarshaller);
            JarFiles.addJarConfiguration(jar);
            return jar;
        }
        if (SystemPluginConfiguration.class.isAssignableFrom(type)) {
            String location = unMarshaller.attribute("location");
            String classname = unMarshaller.attribute("classname");
            JarConfigurationModel jar = JarFiles.getJarConfiguration(location);
            Class<? extends SystemPlugin> pluginClass = jar.getSystemPluginClass(classname);
            try {
                SystemPlugin plugin = pluginClass.newInstance();
                Class<? extends SystemModel> configurationClass = GenericTypeMarshaller.getPluginUIClass(plugin);
                unMarshaller.checkBeginElement("configuration");
                SystemModel ui = GenericTypeMarshaller.fromElement(configurationClass, unMarshaller);
                unMarshaller.checkEndElement("configuration");
                SystemPluginConfiguration prototype = Factory.prototype(SystemPluginConfiguration.class);
                Factory.when(prototype.classname()).thenReturn(classname);
                Factory.when(prototype.location()).thenReturn(location);
                Factory.when(prototype.configuration()).thenReturn(ui);
                return Factory.build(prototype);
            }
            catch (UnmarshallingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (SystemPlugin.class.isAssignableFrom(type)) {
            String location = unMarshaller.attribute("location");
            String classname = unMarshaller.attribute("classname");
            JarConfigurationModel jar = JarFiles.getJarConfiguration(location);
            Class<? extends SystemPlugin> pluginClass = jar.getSystemPluginClass(classname);
            try {
                SystemPlugin plugin = pluginClass.newInstance();
                Class<? extends SystemModel> configurationClass = GenericTypeMarshaller.getPluginUIClass(plugin);
                unMarshaller.checkBeginElement("configuration");
                SystemModel ui = GenericTypeMarshaller.fromElement(configurationClass, unMarshaller);
                unMarshaller.checkEndElement("configuration");
                plugin.setUI(ui);
                return plugin;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (VectorResultType.class.isAssignableFrom(type)) {
            unMarshaller.checkBeginElement(name);
            VectorResultType vec = new VectorResultType(Factory.results().value(unMarshaller.attribute("name"), unMarshaller.attribute("unit")), GenericTypeMarshaller.readVector(unMarshaller));
            unMarshaller.checkEndElement(name);
            return vec;
        }
        return null;
    }

    private static List<Double> readVector(final UnMarshaller unMarshaller) {
        final ArrayList<Double> vector = new ArrayList<Double>();
        unMarshaller.processWrappedElementSequence("values", "value", new Processor(){

            @Override
            public void process() {
                vector.add(new Double(unMarshaller.attribute("v")));
            }
        });
        return vector;
    }

    public static Class<? extends SystemModel> getPluginUIClass(SystemPlugin plugin) {
        return (Class)((ParameterizedType)plugin.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    private static Object recurse(Class type, UnMarshaller unMarshaller, Method method) {
        if (recursionClasses.contains(type)) {
            return GenericTypeMarshaller.unmarshall(unMarshaller, method, null);
        }
        return GenericTypeMarshaller.fromElement(type, unMarshaller);
    }

    private static Object defaultValue(Class<?> clazz, Method method) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(method.getName())) continue;
            try {
                return field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static SystemPluginConfiguration createConfiguration(SystemPlugin<?> plugin) {
        SystemPluginConfiguration prototype = Factory.prototype(SystemPluginConfiguration.class);
        Factory.when(prototype.configuration()).thenReturn((SystemModel)plugin.getUI());
        JarConfigurationModel jar = JarFiles.getJar(plugin);
        Factory.when(prototype.classname()).thenReturn(plugin.getClass().getName());
        Factory.when(prototype.location()).thenReturn(jar.getHash());
        return Factory.build(prototype);
    }

    static {
        recursionClasses.add(EmissionMask.class);
        recursionClasses.add(BlockingMask.class);
        recursionClasses.add(IntermodulationRejectionMask.class);
        recursionClasses.add(BitRateMapping.class);
        recursionClasses.add(Configuration.class);
        recursionClasses.add(JarConfigurationModel.class);
        recursionClasses.add(Double.class);
        recursionClasses.add(Integer.class);
        recursionClasses.add(SystemPluginConfiguration.class);
        recursionClasses.add(SystemPlugin.class);
    }
}

