/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.distributions.ConstantDistribution;
import org.seamcat.model.distributions.DiscreteUniformDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.distributions.LimitedGaussianDistribution;
import org.seamcat.model.distributions.LimitedRayleighDistribution;
import org.seamcat.model.distributions.LogNormalDistribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.distributions.StairDistribution;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.distributions.UniformPolarAngleDistribution;
import org.seamcat.model.distributions.UniformPolarDistanceDistribution;
import org.seamcat.model.distributions.UserDefinedDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.FunctionMarshaller;

public class DistributionMarshaller {
    public static final int TYPE_CONSTANT = 0;
    public static final int TYPE_USER_DEFINED = 1;
    public static final int TYPE_UNIFORM = 2;
    public static final int TYPE_GAUSSIAN = 3;
    public static final int TYPE_RAYLEIGH = 4;
    public static final int TYPE_UNIFORM_POLAR_DISTANCE = 5;
    public static final int TYPE_UNIFORM_POLAR_ANGLE = 6;
    public static final int TYPE_USER_DEFINED_STAIR = 7;
    public static final int TYPE_DISCRETE_UNIFORM = 8;
    public static final int TYPE_LOG_NORMAL = 9;
    public static final int TYPE_GAUSSIAN_LIMITED = 10;
    public static final int TYPE_RAYLEIGH_LIMITED = 11;

    public static Distribution unMarshall(final UnMarshaller unMarshaller) {
        unMarshaller.checkBeginElement("distribution");
        Distribution result = null;
        int type = Integer.parseInt(unMarshaller.attribute("type").trim());
        if (type == 0) {
            double constant = Double.parseDouble(unMarshaller.attribute("constant"));
            result = Factory.distributionFactory().getConstantDistribution(constant);
        } else if (type == 1) {
            final ArrayList<Point2D> _points = new ArrayList<Point2D>();
            unMarshaller.processWrappedElementSequence("user-defined", "point2d", new Processor(){

                @Override
                public void process() {
                    _points.add(FunctionMarshaller.point(unMarshaller));
                }
            });
            result = Factory.distributionFactory().getUserDefined(Factory.functionFactory().discreteFunction(_points));
        } else if (type == 2) {
            double min = Double.parseDouble(unMarshaller.attribute("min"));
            double max = Double.parseDouble(unMarshaller.attribute("max"));
            result = Factory.distributionFactory().getUniformDistribution(min, max);
        } else if (type == 3) {
            double mean = Double.parseDouble(unMarshaller.attribute("mean"));
            double stdDev = Double.parseDouble(unMarshaller.attribute("std-dev"));
            result = Factory.distributionFactory().getGaussianDistribution(mean, stdDev);
        } else if (type == 10) {
            double min = Double.parseDouble(unMarshaller.attribute("min"));
            double max = Double.parseDouble(unMarshaller.attribute("max"));
            double stdDev = Double.parseDouble(unMarshaller.attribute("std-dev"));
            result = Factory.distributionFactory().getLimitedGaussianDistribution(min, max, stdDev);
        } else if (type == 4) {
            double min = Double.parseDouble(unMarshaller.attribute("min"));
            double stdDev = Double.parseDouble(unMarshaller.attribute("std-dev"));
            result = Factory.distributionFactory().getRayleighDistribution(min, stdDev);
        } else if (type == 11) {
            double min = Double.parseDouble(unMarshaller.attribute("min"));
            double max = Double.parseDouble(unMarshaller.attribute("max"));
            double stdDev = Double.parseDouble(unMarshaller.attribute("std-dev"));
            result = Factory.distributionFactory().getLimitedRayleighDistribution(min, max, stdDev);
        } else if (type == 9) {
            double max = Double.parseDouble(unMarshaller.attribute("max"));
            double mean = Double.parseDouble(unMarshaller.attribute("mean"));
            double stdDev = Double.parseDouble(unMarshaller.attribute("std-dev"));
            result = Factory.distributionFactory().getLogNormalDistribution(max, mean, stdDev);
        } else if (type == 5) {
            double maxDistance = Double.parseDouble(unMarshaller.attribute("max-distance"));
            result = Factory.distributionFactory().getUniformPolarDistanceDistribution(maxDistance);
        } else if (type == 6) {
            double maxAngle = Double.parseDouble(unMarshaller.attribute("max-angle"));
            result = Factory.distributionFactory().getUniformPolarAngleDistribution(maxAngle);
        } else if (type == 7) {
            final ArrayList<Point2D> points = new ArrayList<Point2D>();
            unMarshaller.processWrappedElementSequence("user-defined-stair", "point2d", new Processor(){

                @Override
                public void process() {
                    points.add(FunctionMarshaller.point(unMarshaller));
                }
            });
            result = Factory.distributionFactory().getUserDefinedStair(Factory.functionFactory().discreteFunction(points));
        } else if (type == 8) {
            double stepShift;
            double min = Double.parseDouble(unMarshaller.attribute("min"));
            double max = Double.parseDouble(unMarshaller.attribute("max"));
            double step = Double.parseDouble(unMarshaller.attribute("step"));
            try {
                stepShift = Double.parseDouble(unMarshaller.attribute("stepShift"));
            }
            catch (NumberFormatException e) {
                stepShift = step / 2.0;
            }
            result = Factory.distributionFactory().getDiscreteUniformDistribution(min, max, step, stepShift);
        }
        unMarshaller.checkEndElement("distribution");
        return result;
    }

    public static void marshall(Marshaller marshaller, Distribution distribution) {
        marshaller.beginElement("distribution");
        if (distribution instanceof ConstantDistribution) {
            marshaller.attribute("type", String.valueOf(0));
            marshaller.attribute("constant", String.valueOf(((ConstantDistribution)distribution).getConstant()));
        } else if (distribution instanceof UserDefinedDistribution) {
            marshaller.attribute("type", String.valueOf(1));
            marshaller.beginElement("user-defined");
            Function cdf = ((UserDefinedDistribution)distribution).getCdf();
            FunctionMarshaller.marshall(marshaller, cdf);
            marshaller.endElement("user-defined");
        } else if (distribution instanceof UniformDistribution) {
            marshaller.attribute("type", String.valueOf(2));
            UniformDistribution dist = (UniformDistribution)distribution;
            marshaller.attribute("min", String.valueOf(dist.getMin()));
            marshaller.attribute("max", String.valueOf(dist.getMax()));
        } else if (distribution instanceof GaussianDistribution) {
            marshaller.attribute("type", String.valueOf(3));
            GaussianDistribution dist = (GaussianDistribution)distribution;
            marshaller.attribute("mean", String.valueOf(dist.getMean()));
            marshaller.attribute("std-dev", String.valueOf(dist.getStdDev()));
        } else if (distribution instanceof RayleighDistribution) {
            marshaller.attribute("type", String.valueOf(4));
            RayleighDistribution dist = (RayleighDistribution)distribution;
            marshaller.attribute("std-dev", String.valueOf(dist.getStdDev()));
            marshaller.attribute("min", String.valueOf(dist.getMin()));
        } else if (distribution instanceof UniformPolarDistanceDistribution) {
            marshaller.attribute("type", String.valueOf(5));
            UniformPolarDistanceDistribution dist = (UniformPolarDistanceDistribution)distribution;
            marshaller.attribute("max-distance", String.valueOf(dist.getMaxDistance()));
        } else if (distribution instanceof UniformPolarAngleDistribution) {
            marshaller.attribute("type", String.valueOf(6));
            marshaller.attribute("max-angle", String.valueOf(((UniformPolarAngleDistribution)distribution).getMaxAngle()));
        } else if (distribution instanceof StairDistribution) {
            marshaller.attribute("type", String.valueOf(7));
            marshaller.beginElement("user-defined-stair");
            StairDistribution sd = (StairDistribution)distribution;
            Function cdf = sd.getCdf();
            List<Point2D> points = cdf.getPoints();
            for (Point2D p : points) {
                marshaller.beginElement("point2d");
                marshaller.attribute("x", String.valueOf(p.getX()));
                marshaller.attribute("y", String.valueOf(p.getY()));
                marshaller.endElement("point2d");
            }
            marshaller.endElement("user-defined-stair");
        } else if (distribution instanceof DiscreteUniformDistribution) {
            marshaller.attribute("type", String.valueOf(8));
            DiscreteUniformDistribution dist = (DiscreteUniformDistribution)distribution;
            marshaller.attribute("min", String.valueOf(dist.getMin()));
            marshaller.attribute("max", String.valueOf(dist.getMax()));
            marshaller.attribute("step", String.valueOf(dist.getStep()));
            marshaller.attribute("stepShift", String.valueOf(dist.getStepShift()));
        } else if (distribution instanceof LimitedGaussianDistribution) {
            marshaller.attribute("type", String.valueOf(10));
            LimitedGaussianDistribution dist = (LimitedGaussianDistribution)distribution;
            marshaller.attribute("min", String.valueOf(dist.getMax()));
            marshaller.attribute("max", String.valueOf(dist.getMax()));
            marshaller.attribute("mean", String.valueOf(dist.getMean()));
            marshaller.attribute("std-dev", String.valueOf(dist.getStdDev()));
        } else if (distribution instanceof LimitedRayleighDistribution) {
            marshaller.attribute("type", String.valueOf(11));
            LimitedRayleighDistribution dist = (LimitedRayleighDistribution)distribution;
            marshaller.attribute("min", String.valueOf(dist.getMin()));
            marshaller.attribute("max", String.valueOf(dist.getMax()));
            marshaller.attribute("std-dev", String.valueOf(dist.getStdDev()));
        } else if (distribution instanceof LogNormalDistribution) {
            marshaller.attribute("type", String.valueOf(9));
            LogNormalDistribution dist = (LogNormalDistribution)distribution;
            marshaller.attribute("mean", String.valueOf(dist.getMean()));
            marshaller.attribute("max", String.valueOf(dist.getMax()));
            marshaller.attribute("std-dev", String.valueOf(dist.getStdDev()));
        }
        marshaller.endElement("distribution");
    }
}

