/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.dmasystems.UserShouldBeIgnoredException;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.UplinkOfdmaBaseStation;
import org.seamcat.ofdma.UplinkOfdmaMobile;
import org.seamcat.simulation.cellular.ofdma.OFDMAUpLink;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;

public class UplinkOfdmaSystem
extends OfdmaSystem<UplinkOfdmaMobile> {
    public static final UniqueValueDef COUPLING_LOSS_PERCENTILE = Factory.results().single("Coupling loss percentile", "");
    private double[] clValues;

    @Override
    public UplinkOfdmaMobile generateUserTerminal() {
        return new UplinkOfdmaMobile(new Point2D(0.0, 0.0), this, this.useridcount++, this.getPlugin().getMs().getAntennaGain().trial(), this.getPlugin().getMs().getAntennaHeight().trial());
    }

    public UplinkOfdmaSystem(AbstractDmaSystem<?> dma) {
        super(dma);
        if (this.getOFDMASettings().getUpLinkSettings() == null) {
            this.getOFDMASettings().setUpLinkSettings(new OFDMAUpLink());
        }
        this.getOFDMASettings().setDownLinkSettings(null);
    }

    @Override
    protected void configureBaseStation(AbstractDmaBaseStation base) {
        base.resetBaseStation();
    }

    @Override
    protected OfdmaBaseStation generateBaseStation(Point2D position, int cellid, double antennaHeight, double antennaTilt, int sectorid, boolean triSector) {
        return new UplinkOfdmaBaseStation<UplinkOfdmaMobile>(position, this, cellid, antennaHeight, antennaTilt, sectorid, triSector);
    }

    protected OfdmaBaseStation[][] generateBaseStationArray() {
        return new UplinkOfdmaBaseStation[this.getNumberOfCellSitesInPowerControlCluster()][this.cellsPerSite()];
    }

    public List<AbstractDmaLink> getActiveConnections() {
        ArrayList<AbstractDmaLink> links = new ArrayList<AbstractDmaLink>(this.getActiveUsers().size());
        for (AbstractDmaBaseStation base : this.getAllBaseStations()) {
            links.addAll(base.getOldTypeActiveConnections());
        }
        return links;
    }

    protected void powerControl() {
        for (int i = 0; i < this.getActiveUsers().size(); ++i) {
            UplinkOfdmaMobile mobile = (UplinkOfdmaMobile)this.getActiveUsers().get(i);
            mobile.calculateSINR();
        }
    }

    @Override
    protected void performSystemSpecificInitialization(UplinkOfdmaMobile user) throws UserShouldBeIgnoredException {
        user.setCurrentTransmitPower_dBm(this.getOFDMASettings().getUpLinkSettings().getMaximumAllowedTransmitPowerOfMS());
    }

    protected void scalePower(UplinkOfdmaMobile user, double pathloss_limit) {
        double minTxpower = this.getOFDMASettings().getUpLinkSettings().getMinimumTransmitPowerOfMS();
        double maxTxpower = this.getOFDMASettings().getUpLinkSettings().getMaximumAllowedTransmitPowerOfMS();
        double rMin_linear = Mathematics.fromdBm2Watt(minTxpower) / Mathematics.fromdBm2Watt(maxTxpower);
        double pathloss = user.getServingLink().getEffectivePathloss();
        double test_ratio_linear = Mathematics.fromdBm2Watt(pathloss) / Mathematics.fromdBm2Watt(pathloss_limit);
        double p_watt = Mathematics.fromdBm2Watt(this.getOFDMASettings().getUpLinkSettings().getMaximumAllowedTransmitPowerOfMS()) * Math.min(1.0, Math.max(rMin_linear, Math.pow(test_ratio_linear, this.getOFDMASettings().getUpLinkSettings().getBalancingFactor())));
        user.setCurrentTransmitPower_dBm(Mathematics.fromWatt2dBm(p_watt));
    }

    @Override
    public void performPreSimulationTasks(double frequency) {
        super.performPreSimulationTasks(frequency);
        OptionalValue<Double> percentile = ((HybridOFDMAUpLinkPlugin)this.getPlugin()).getPercentile();
        if (percentile.isRelevant()) {
            this.getPreSimulation().getSingleValueTypes().add(new DoubleResultType(COUPLING_LOSS_PERCENTILE, percentile.getValue()));
        } else {
            int i;
            ArrayList<Double> effectivePathLoss = new ArrayList<Double>();
            this.resetSystem();
            while (effectivePathLoss.size() < 1000) {
                this.setupSystem();
                for (i = 0; i < this.getActiveUsers().size(); ++i) {
                    effectivePathLoss.add(((UplinkOfdmaMobile)this.getActiveUsers().get(i)).getServingLink().getEffectivePathloss());
                }
            }
            this.clValues = new double[effectivePathLoss.size()];
            for (i = 0; i < effectivePathLoss.size(); ++i) {
                this.clValues[i] = (Double)effectivePathLoss.get(i);
            }
            Arrays.sort(this.clValues);
            this.getPreSimulation().getSingleValueTypes().add(new DoubleResultType(COUPLING_LOSS_PERCENTILE, this.calculatePowerControlledPathlossLimit(this.clValues)));
        }
    }

    public double[] getClValues() {
        return this.clValues;
    }

    protected double calculatePowerControlledPathlossLimit(double[] effectivePathLoss) {
        int floor = (int)Math.floor(this.getOFDMASettings().getUpLinkSettings().getPowerScalingThreshold() / (1.0 / (double)effectivePathLoss.length));
        return effectivePathLoss[floor];
    }

    private void setupSystem() {
        super.performPreSimulationTasks(this.getFrequency());
        do {
            this.generateAndPositionMobiles();
        } while (!this.initiateConnections());
    }

    @Override
    public void simulateLinkSpecifics() {
        for (UplinkOfdmaMobile mobile : this.getActiveUsers()) {
            this.scalePower(mobile, this.getPreSimulation().findDoubleValue(COUPLING_LOSS_PERCENTILE));
        }
        this.powerControl();
    }
}

