/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.ofdma.UplinkOfdmaMobile;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.cellular.ofdma.OFDMAUpLink;

public class UplinkOfdmaBaseStation<UserType extends UplinkOfdmaMobile>
extends OfdmaBaseStation {
    private int activeSize;
    private int inActiveSize;
    private double cache;
    private static double adjustmentFactorForNonCoLocatedResourceBlock = 30.0;

    public UplinkOfdmaBaseStation(Point2D position, OfdmaSystem<UserType> _system, int _cellid, double antHeight, double antennaTilt, int sectorId, boolean triSector) {
        super(position, _system, _cellid, antHeight, antennaTilt, sectorId, triSector);
    }

    public double calculateTotalInterference_Watt(OfdmaUplink excludeLink) {
        AbstractDmaLink link;
        int i;
        double I_thermal_dBm = this.system.getPreSimulation().findDoubleValue(OfdmaSystem.THERMAL_NOISE_UE);
        double sum_Watt = this.cache;
        int resourceBlockNo = excludeLink.getResourceBlockNumber();
        if (this.activeSize < this.activeConnections.size()) {
            for (i = this.activeSize; i < this.activeConnections.size(); ++i) {
                link = (AbstractDmaLink)this.activeConnections.get(i);
                this.cache += this.currentReceivePowerWatt(link);
                ++this.activeSize;
            }
            sum_Watt = this.cache;
        }
        if (this.inActiveSize < this.inActiveConnections.size()) {
            for (i = this.inActiveSize; i < this.inActiveConnections.size(); ++i) {
                link = (AbstractDmaLink)this.inActiveConnections.get(i);
                this.cache += this.currentReceivePowerWatt(link);
                ++this.inActiveSize;
            }
            sum_Watt = this.cache;
        }
        sum_Watt -= this.currentReceivePowerWatt(excludeLink);
        if (this.system.getOFDMASettings().getUpLinkSettings().isUseNumberOfActiveMsPerBs()) {
            Double percentage = this.system.getOFDMASettings().getUpLinkSettings().getFrequencyScheduling().get(resourceBlockNo);
            int sameRB = (int)Math.round((double)this.inActiveConnections.size() * percentage / 100.0);
            while (sameRB > 0) {
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, (AbstractDmaLink)this.inActiveConnections.get(--sameRB));
            }
            for (AbstractDmaLink connection : this.activeConnections) {
                OfdmaUplink conn;
                if (connection == excludeLink || (conn = (OfdmaUplink)connection).getResourceBlockNumber() != resourceBlockNo) continue;
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, conn);
            }
        } else {
            int users = this.activeConnections.size();
            int rounds = this.inActiveConnections.size() / users;
            for (int i2 = 0; i2 < rounds; ++i2) {
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, (AbstractDmaLink)this.inActiveConnections.get(users * i2 + resourceBlockNo));
            }
        }
        this.setInterSystemInterference(Mathematics.fromWatt2dBm(sum_Watt));
        return Mathematics.fromdBm2Watt(I_thermal_dBm) + sum_Watt;
    }

    private double currentReceivePowerWatt(AbstractDmaLink link) {
        double inter_dBm = link.calculateCurrentReceivePower_dBm() - adjustmentFactorForNonCoLocatedResourceBlock;
        return Mathematics.fromdBm2Watt(inter_dBm);
    }

    private double adjustForCoLocatedResourceBlock(double sum_Watt, AbstractDmaLink link) {
        sum_Watt -= this.currentReceivePowerWatt(link);
        return sum_Watt += Mathematics.fromdBm2Watt(link.calculateCurrentReceivePower_dBm());
    }

    @Override
    public boolean initialConnect() {
        boolean candidatesAvailable;
        int sum = this.getSubCarriersInUse();
        OFDMASettings ofdmaSettings = this.system.getOFDMASettings();
        OFDMAUpLink upLinkSettings = ofdmaSettings.getUpLinkSettings();
        int limit = upLinkSettings.isUseNumberOfActiveMsPerBs() ? upLinkSettings.getNumberOfActiveMsPerBs() : (int)Math.floor((double)ofdmaSettings.getMaxSubCarriersPerBaseStation() / (double)ofdmaSettings.getNumberOfSubCarriersPerMobileStation());
        int count = sum / ofdmaSettings.getNumberOfSubCarriersPerMobileStation();
        boolean underLoaded = count < limit;
        boolean bl = candidatesAvailable = this.candidateList.size() > 0;
        while (underLoaded && candidatesAvailable) {
            AbstractDmaLink candidate = this.fetchRandomCandidate();
            ++count;
            sum += ofdmaSettings.getNumberOfSubCarriersPerMobileStation();
            this.activeConnections.add(candidate);
            candidate.activateLink();
            candidatesAvailable = this.candidateList.size() > 0;
            underLoaded = count < limit;
        }
        this.setSubCarriersInUse(sum);
        return !underLoaded;
    }
}

