/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaSystem;

public class OfdmaBaseStation
extends AbstractDmaBaseStation {
    protected List<AbstractDmaLink> candidateList;
    protected OfdmaSystem system;
    private final boolean triSector;

    public OfdmaBaseStation(Point2D position, OfdmaSystem _system, int _cellid, double antHeight, double antTilt, int sectorId, boolean triSector) {
        super(position, _system, _cellid, antHeight, antTilt, sectorId);
        this.system = _system;
        this.triSector = triSector;
        this.candidateList = new ArrayList<AbstractDmaLink>();
    }

    public double calculateAggregateBitrateAchieved() {
        double sum = 0.0;
        List<AbstractDmaLink> links = this.getOldTypeActiveConnections();
        for (AbstractDmaLink link : links) {
            sum += ((OfdmaMobile)link.getUserTerminal()).calculateAchievedBitrate();
        }
        return sum;
    }

    public double calculateCurrentTransmitPower_Watt() {
        return this.getMaximumTransmitPower_Watt() * (double)this.getSubCarriersInUse() / (double)this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation();
    }

    @Override
    public double calculateTotalInterference_dBm(AbstractDmaLink excludeLink) {
        throw new RuntimeException("No used in ODFMA");
    }

    @Override
    public double calculateInterferenceWithoutExternal_dBm(AbstractDmaLink excludeLink) {
        return 0.0;
    }

    @Override
    public int countActiveUsers() {
        return this.activeConnections.size();
    }

    @Override
    public int countInActiveUsers() {
        return this.inactiveUsers.size();
    }

    @Override
    public double getCurrentTransmitPower_dBm() {
        return Mathematics.fromWatt2dBm(this.calculateCurrentTransmitPower_Watt());
    }

    public boolean initialConnect() {
        boolean candidatesAvailable;
        int sum = this.getSubCarriersInUse();
        double loadFactor = Math.rint(sum) / Math.rint(this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation());
        boolean underLoaded = loadFactor < 1.0;
        boolean bl = candidatesAvailable = this.candidateList.size() > 0;
        while (underLoaded && candidatesAvailable) {
            AbstractDmaLink candidate = this.fetchRandomCandidate();
            int temp = this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
            if (sum + temp <= this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation()) {
                sum += temp;
                this.activeConnections.add(candidate);
                candidate.activateLink();
            }
            candidatesAvailable = this.candidateList.size() > 0;
            loadFactor = Math.rint(sum) / Math.rint(this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation());
            underLoaded = loadFactor < 1.0 && this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation() <= this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation() - sum;
        }
        this.setSubCarriersInUse(sum);
        return !underLoaded;
    }

    public AbstractDmaLink fetchRandomCandidate() {
        int i = RandomAccessor.getRandom().nextInt(this.candidateList.size());
        return this.candidateList.remove(i);
    }

    @Override
    public void resetBaseStation() {
        this.activeConnections.clear();
        this.inActiveConnections.clear();
        this.inactiveUsers.clear();
        this.candidateList.clear();
        this.setSubCarriersInUse(0);
    }

    @Override
    public void intializeConnection(AbstractDmaLink link) {
        this.candidateList.add(link);
    }

    public int getLinkIndexOfActiveUser(AbstractDmaLink link) {
        return this.activeConnections.indexOf(link);
    }

    public String toString() {
        return "OfdmaBaseStation #" + this.getCellid() + " (" + this.activeConnections.size() + " active connections)";
    }

    @Override
    public void addInActiveConnection(AbstractDmaLink link) {
        super.addInActiveConnection(link);
        this.candidateList.remove(link);
    }

    @Override
    public String getName() {
        if (this.triSector) {
            return "BS Cell #" + this.getCellid() / 3 + " Sector " + this.getSectorId();
        }
        return "BS Cell #" + this.getCellid();
    }
}

