/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.dmasystems.UserShouldBeIgnoredException;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.simulation.cellular.ofdma.OFDMADownLink;

public class DownlinkOfdmaSystem
extends OfdmaSystem<DownlinkOfdmaMobile> {
    public DownlinkOfdmaSystem(AbstractDmaSystem<?> dma) {
        super(dma);
        if (this.getOFDMASettings().getDownLinkSettings() == null) {
            this.getOFDMASettings().setDownLinkSettings(new OFDMADownLink());
        }
        this.getOFDMASettings().setUpLinkSettings(null);
    }

    @Override
    protected void configureBaseStation(AbstractDmaBaseStation base) {
        base.resetBaseStation();
        base.setMaximumTransmitPower_dBm(this.getMaximumTransmitPowerBasestation());
    }

    @Override
    protected OfdmaBaseStation generateBaseStation(Point2D position, int cellid, double antennaHeight, double antennaTilt, int sectorid, boolean triSector) {
        return new OfdmaBaseStation(position, this, cellid, antennaHeight, antennaTilt, sectorid, triSector);
    }

    protected OfdmaBaseStation[][] generateBaseStationArray() {
        return new OfdmaBaseStation[this.getNumberOfCellSitesInPowerControlCluster()][this.cellsPerSite()];
    }

    @Override
    public DownlinkOfdmaMobile generateUserTerminal() {
        return new DownlinkOfdmaMobile(new Point2D(0.0, 0.0), this, this.useridcount++, this.getPlugin().getMs().getAntennaGain().trial(), this.getPlugin().getMs().getAntennaHeight().trial());
    }

    @Override
    protected void performSystemSpecificInitialization(DownlinkOfdmaMobile user) throws UserShouldBeIgnoredException {
    }

    protected void initializeBaseStations() {
        for (AbstractDmaBaseStation base : this.getAllBaseStations()) {
            ((OfdmaBaseStation)base).calculateCurrentTransmitPower_Watt();
        }
    }

    @Override
    public void simulateLinkSpecifics() {
        this.initializeBaseStations();
    }

    public double getMaximumTransmitPowerBasestation() {
        return this.getOFDMASettings().getDownLinkSettings().getBSMaximumTransmitPower();
    }
}

