/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.types.result;

import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.ResultType;

public class FunctionResultType
implements ResultType<Function> {
    private UniqueValueDef def;
    private Function function;

    public FunctionResultType(UniqueValueDef def, Function function) {
        this.def = def;
        this.function = function;
    }

    @Override
    public Function value() {
        return this.function;
    }

    @Override
    public String description() {
        if (this.function.isConstant()) {
            return "Constant function[" + this.function.getConstant() + "]";
        }
        String points = "[" + this.function.getPoints().size() + " points]";
        if (this.function instanceof MaskFunction) {
            return "Mask function" + points;
        }
        return "Function" + points;
    }

    @Override
    public UniqueValueDef def() {
        return this.def;
    }

    public String toString() {
        return this.def.name();
    }
}

