/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.types;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;

public final class Transmitter {
    public static final UniqueValueDef NORMALIZED_EMISSION_MASK = Factory.results().function("Normalized emission mask", "MHz", "dBc");
    public static final UniqueValueDef NORMALIZED_EMISSION_FLOOR = Factory.results().function("Normalized emission floor", "MHz", "dBc");
    private final EmissionMask emissionMask;
    private final MaskFunction emissionFloor;
    private final boolean usingEmissionFloor;
    private final double bandwidth;
    private final Bounds bandwidthBounds;
    private final List<LocalEnvironment> localEnvironments;
    private final AntennaGain antennaGain;
    private final Distribution height;
    private final double bandwidthOffset;
    private final boolean usePowerControl;

    public Transmitter(EmissionMask emissionMask, MaskFunction emissionFloor, boolean usingEmissionFloor, double bandwidth, Bounds bandwidthBounds, List<LocalEnvironment> localEnvironments, AntennaGain antennaGain, Distribution height, double bandwidthOffset, boolean usePowerControl) {
        this.emissionMask = emissionMask;
        this.emissionFloor = emissionFloor;
        this.usingEmissionFloor = usingEmissionFloor;
        this.bandwidth = bandwidth;
        this.bandwidthBounds = bandwidthBounds;
        this.localEnvironments = localEnvironments;
        this.antennaGain = antennaGain;
        this.height = height;
        this.bandwidthOffset = bandwidthOffset;
        this.usePowerControl = usePowerControl;
    }

    public EmissionMask getEmissionsMask() {
        return this.emissionMask;
    }

    public MaskFunction getEmissionsFloor() {
        return this.emissionFloor;
    }

    public boolean isUsingEmissionsFloor() {
        return this.usingEmissionFloor;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getBandwidthOffset() {
        return this.bandwidthOffset;
    }

    public Bounds getBandwidthBounds() {
        return this.bandwidthBounds;
    }

    public List<LocalEnvironment> getLocalEnvironments() {
        return this.localEnvironments;
    }

    public AntennaGain getAntennaGain() {
        return this.antennaGain;
    }

    public Distribution getHeight() {
        return this.height;
    }

    public boolean isUsingPowerControl() {
        return this.usePowerControl;
    }
}

