/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.simulation;

import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.systems.ofdmauplink.simulation.Link;

public class VictimImpl
extends DefaultVictimImpl<VictimImpl> {
    private Link connection;
    private double achievedSINR;
    private double achievedBitrate;

    public VictimImpl(Link connection) {
        super(connection.getBaseStation().getAntennaGain(), connection.getLinkResult());
        this.connection = connection;
    }

    public void calculateAchievedSINRWatt() {
        double rPowerWatt = Mathematics.fromdBm2Watt(this.connection.getUserTerminal().getServingLink().getCurrentReceivePower());
        double totalInterferenceWatt = this.connection.getUserTerminal().getTotalInterferenceWatt();
        double extIntWatt = Mathematics.fromdBm2Watt(this.getTotalInterferenceBlocking()) + Mathematics.fromdBm2Watt(this.getTotalInterferenceUnwanted());
        double v = rPowerWatt / (totalInterferenceWatt + extIntWatt);
        this.achievedSINR = Mathematics.linear2dB(v);
    }

    public boolean isConnectedToReferenceCell() {
        return this.connection.getBaseStation().isReferenceCell();
    }

    public double getNonInterferedAchievedSINR() {
        return this.connection.getUserTerminal().getAchievedSINR();
    }

    public double getAchievedSINR() {
        return this.achievedSINR;
    }

    public double getNonInterferedAchievedBitrate() {
        return this.connection.getUserTerminal().getAchievedBitrate();
    }

    public double getAchievedBitrate() {
        return this.achievedBitrate;
    }

    public double getReceivePower() {
        return this.connection.getCurrentReceivePower();
    }

    public double getUEFrequency() {
        return this.connection.getUserTerminal().getFrequency();
    }

    @Override
    public boolean isSameTx(VictimImpl other) {
        return this.connection.getBaseStation().getCellid() == other.connection.getBaseStation().getCellid();
    }

    public void calculateAchievedBitrate() {
        double maxAch = this.connection.getUserTerminal().getMaxAchievableBitRate(this.achievedSINR);
        int requestedSubCarriers = this.connection.getPlugin().getMaxRBsPrMS();
        this.achievedBitrate = (double)requestedSubCarriers * (maxAch / (double)this.connection.getPlugin().getMaxRBsPrBS());
    }

    public double getCurrentTransmitPower() {
        return this.connection.getUserTerminal().getCurrentTransmitPower();
    }
}

