/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.simulation;

import java.util.Arrays;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.simulation.BaseStation;
import org.seamcat.model.systems.ofdmauplink.simulation.Link;
import org.seamcat.simulation.cellular.PathLossCorrelation;

class MobileStation {
    private Link[] links;
    private Link servingLink;
    private OFDMAUpLinkSystemPlugin plugin;
    private double antennaHeight;
    private double frequency;
    private RadioSystem system;
    private final int userid;
    private Point2D position;
    private double antennaGain;
    private double currentTransmitPower;
    private double achievedSINR;
    private double achievedBitrate;
    private double totalInterferenceWatt;

    public double getFrequency() {
        return this.frequency;
    }

    public MobileStation(double frequency, OFDMAUpLinkSystemPlugin plugin, RadioSystem system, int _userid) {
        this.frequency = frequency;
        this.system = system;
        this.userid = _userid;
        this.position = Point2D.ORIGIN;
        this.antennaHeight = plugin.getMobileStationHeight().trial();
        this.antennaGain = plugin.getMobileStationGain().trial();
        this.plugin = plugin;
        this.currentTransmitPower = plugin.getMaximumAllowedTransmitPowerOfMS();
    }

    public Link getServingLink() {
        return this.servingLink;
    }

    public void setServingLink(Link servingLink, int resourceBlockNumber) {
        this.servingLink = servingLink;
        this.frequency = this.plugin.calculateFrequency(resourceBlockNumber, this.frequency);
        servingLink.getLinkResult().setFrequency(this.frequency);
        for (Link link : this.links) {
            if (link == servingLink) continue;
            link.getBaseStation().removeCandidate(link);
            link.getBaseStation().addInActive(link);
        }
    }

    private void sortLinks() {
        Arrays.sort(this.links, Link.comparator);
    }

    public Point2D getPosition() {
        return this.position;
    }

    public double getAntennaGain() {
        return this.antennaGain;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(0.0);
        ant.setPosition(this.position);
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void linkToBSAndAddToCandidateList(BaseStation[][] cells) {
        this.links = new Link[cells.length * cells[0].length];
        int linkid = 0;
        PathLossCorrelation correlation = this.plugin.getPathLossCorrelation();
        double correlationInterSite = correlation.getCorrelationFactor();
        double a_inter = Math.sqrt(Math.abs(correlationInterSite));
        double b_inter = Math.sqrt(1.0 - Math.abs(correlationInterSite));
        double x = correlation.trial();
        for (int i = 0; i < cells.length; ++i) {
            int j = 0;
            while (j < cells[i].length) {
                double y = correlation.trial();
                double pathLossOffset = 0.0;
                if (correlation.isUsingPathLossCorrelation()) {
                    pathLossOffset = a_inter * x + b_inter * y;
                }
                this.links[linkid] = new Link(this.plugin, this.system, cells[i][j], this, this.frequency, pathLossOffset);
                ++j;
                ++linkid;
            }
        }
        this.sortLinks();
        this.links[0].getBaseStation().addCandidate(this.links[0]);
        if (this.links.length > 1) {
            int index = 1;
            double lowestLink = this.links[0].getEffectivePathloss();
            double nextLink = this.links[index].getEffectivePathloss();
            while (lowestLink + this.plugin.getHandoverMargin() > nextLink) {
                this.links[index].getBaseStation().addCandidate(this.links[index]);
                if (++index < this.links.length) {
                    nextLink = this.links[index].getEffectivePathloss();
                    continue;
                }
                return;
            }
        }
    }

    public int getUserid() {
        return this.userid;
    }

    void scalePower(double pathloss_limit) {
        double minTxpower = this.plugin.getMinimumTransmitPowerOfMS();
        double maxTxpower = this.plugin.getMaximumAllowedTransmitPowerOfMS();
        double rMin_linear = Mathematics.fromdBm2Watt(minTxpower) / Mathematics.fromdBm2Watt(maxTxpower);
        double pathloss = this.servingLink.getEffectivePathloss();
        double test_ratio_linear = Mathematics.fromdBm2Watt(pathloss) / Mathematics.fromdBm2Watt(pathloss_limit);
        double p_watt = Mathematics.fromdBm2Watt(this.plugin.getMaximumAllowedTransmitPowerOfMS()) * Math.min(1.0, Math.max(rMin_linear, Math.pow(test_ratio_linear, this.plugin.getBalancingFactor())));
        this.currentTransmitPower = Mathematics.fromWatt2dBm(p_watt);
        this.servingLink.calculateCurrentReceivePower();
    }

    public double getCurrentTransmitPower() {
        return this.currentTransmitPower;
    }

    public void calculateSINR(double thermalNoiseUE) {
        double rPowerWatt = Mathematics.fromdBm2Watt(this.servingLink.getCurrentReceivePower());
        this.totalInterferenceWatt = this.servingLink.getBaseStation().calculateTotalInterference_Watt(this.servingLink) + Mathematics.fromdBm2Watt(thermalNoiseUE);
        this.achievedSINR = Mathematics.linear2dB(rPowerWatt / this.totalInterferenceWatt);
    }

    public double getAchievedSINR() {
        return this.achievedSINR;
    }

    double getTotalInterferenceWatt() {
        return this.totalInterferenceWatt;
    }

    public void calculateAchievedBitrate() {
        double maxAch = this.getMaxAchievableBitRate(this.achievedSINR);
        int requestedSubCarriers = this.plugin.getMaxRBsPrMS();
        this.achievedBitrate = (double)requestedSubCarriers * (maxAch / (double)this.plugin.getMaxRBsPrBS());
    }

    public double getAchievedBitrate() {
        return this.achievedBitrate;
    }

    double getMaxAchievableBitRate(double sinr) {
        Function function = this.plugin.getBitRateMapping();
        double value = 0.0;
        if (sinr < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinr > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinr);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.plugin.getBandwidthOfAnRB() * (double)this.plugin.getMaxRBsPrMS() * value;
    }

    public String toString() {
        return "MS#" + this.userid + " " + this.getPosition();
    }
}

