/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.simulation;

import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.simulation.BaseStation;
import org.seamcat.model.systems.ofdmauplink.simulation.MobileStation;

class Link {
    protected static final Logger LOG = Logger.getLogger(Link.class);
    static Comparator<Link> comparator = new Comparator<Link>(){

        @Override
        public int compare(Link l1, Link l2) {
            double l2Result;
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 == null) {
                return -1;
            }
            if (l2 == null) {
                return 1;
            }
            double l1Result = l1.txRxPathLoss - l1.gainSum();
            if (l1Result > (l2Result = l2.txRxPathLoss - l2.gainSum())) {
                return 1;
            }
            if (l1Result < l2Result) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private BaseStation basestation;
    private OFDMAUpLinkSystemPlugin plugin;
    private RadioSystem system;
    private MobileStation user;
    private double currentReceivePower;
    private double txRxPathLoss;
    private double effectivePathLoss;
    private LinkResult linkResult;
    private Integer resourceBlockNumber;

    public Link(OFDMAUpLinkSystemPlugin plugin, RadioSystem system, BaseStation BS, MobileStation MS, double frequency, double pathLossOffset) {
        this.plugin = plugin;
        this.system = system;
        this.initialize(BS, MS, frequency);
        this.setTxRxPathLoss(plugin.getPropagationModel().evaluate(this.linkResult) + pathLossOffset);
    }

    public Link(OFDMAUpLinkSystemPlugin plugin, RadioSystem system, BaseStation BS, MobileStation MS, double frequency, double pathLoss, boolean cachedEffectivePathLoss) {
        this.plugin = plugin;
        this.system = system;
        this.initialize(BS, MS, frequency);
        this.setTxRxPathLoss(pathLoss);
    }

    private void setTxRxPathLoss(double txRxPathLoss) {
        this.txRxPathLoss = txRxPathLoss;
        this.linkResult.setTxRxPathLoss(txRxPathLoss);
        this.effectivePathLoss = Math.max(this.linkResult.getTxRxPathLoss() - this.gainSum(), this.plugin.getMinimumCouplingLoss());
        this.linkResult.setEffectiveTxRxPathLoss(this.effectivePathLoss);
    }

    private void initialize(BaseStation BS, MobileStation MS, double frequency) {
        this.linkResult = Factory.results().linkResult(this.system, frequency);
        this.user = MS;
        this.basestation = BS;
        AntennaResult tx = this.linkResult.txAntenna();
        AntennaResult rx = this.linkResult.rxAntenna();
        this.basestation.setAntennaProperties(rx);
        this.user.setAntennaProperties(tx);
        this.linkResult.setTxRxDistance(Mathematics.distance(this.user.getPosition(), this.basestation.getPosition()));
        rx.setElevationCompensation(0.0);
        tx.setElevationCompensation(0.0);
        double txRxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(rx.getPosition(), tx.getPosition()));
        double rxTxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(tx.getPosition(), rx.getPosition()));
        this.linkResult.setTxRxAngle(txRxAzi);
        double txRxEle = Mathematics.calculateElevation(tx, rx);
        rx.setAzimuth(rxTxAzi);
        rx.setElevation(-txRxEle);
        tx.setAzimuth(txRxAzi);
        tx.setElevation(txRxEle);
        rx.setGain(this.basestation.getAntennaGain().evaluate(this.linkResult, rx));
        tx.setGain(this.user.getAntennaGain());
        this.linkResult.setValue(SystemPlugin.BANDWIDTH_CORRECTION, Mathematics.linear2dB((double)this.plugin.getMaxRBsPrMS() / (double)this.plugin.getMaxRBsPrBS()));
    }

    public OFDMAUpLinkSystemPlugin getPlugin() {
        return this.plugin;
    }

    private double gainSum() {
        return this.linkResult.txAntenna().getGain() + this.linkResult.rxAntenna().getGain();
    }

    public BaseStation getBaseStation() {
        return this.basestation;
    }

    public double getEffectivePathloss() {
        return this.effectivePathLoss;
    }

    public MobileStation getUserTerminal() {
        return this.user;
    }

    public double getTxRxPathLoss() {
        return this.txRxPathLoss;
    }

    public double getDistance() {
        return this.linkResult.getTxRxDistance();
    }

    public LinkResult getLinkResult() {
        return this.linkResult;
    }

    public void calculateCurrentReceivePower() {
        double chPower = this.getUserTerminal().getCurrentTransmitPower();
        this.currentReceivePower = chPower - this.getEffectivePathloss();
    }

    public double getCurrentReceivePower() {
        return this.currentReceivePower;
    }

    public String toString() {
        return "IMT-2020 DownLink: BS #" + this.getBaseStation().getCellid() + " -> Mobile #" + this.getUserTerminal().getUserid() + " PL = " + this.getEffectivePathloss();
    }

    public int getResourceBlockNumber() {
        return this.resourceBlockNumber;
    }

    public void activateLink() {
        this.resourceBlockNumber = this.findResourceBlockNumber();
        this.getUserTerminal().setServingLink(this, this.resourceBlockNumber);
    }

    private int findResourceBlockNumber() {
        if (this.plugin.useNumberOfActiveMsPerBs()) {
            int index;
            List<Double> props = this.plugin.getProbabilities();
            double pick = RandomAccessor.getRandom().nextDouble() * 100.0;
            double limit = 0.0;
            for (index = 0; index < props.size() - 1 && !(pick < (limit += props.get(index).doubleValue())); ++index) {
            }
            return index;
        }
        return this.getBaseStation().getLinkIndexOfActiveUser(this);
    }
}

