/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.correlation.Correlated;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLink;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLinkDefinition;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralSettings;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.systems.ofdma.TransmitterSettings;
import org.seamcat.model.systems.ofdmauplink.simulation.CouplingLossEstimator;
import org.seamcat.model.systems.ofdmauplink.simulation.OFDMAUpLinkSimulation;
import org.seamcat.model.systems.ofdmauplink.simulation.VictimImpl;
import org.seamcat.model.systems.ofdmauplink.ui.ConsistencyCheck;
import org.seamcat.model.systems.ofdmauplink.ui.SystemModelOFDMAUpLink;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class OFDMAUpLinkSystemPlugin
implements SystemPlugin<SystemModelOFDMAUpLink>,
CorrelationDefinitions,
InterferenceNames,
AsVictimInterferingLink {
    public static final UniqueValueDef SIMULATION_FREQUENCY = Factory.results().single("Frequency", "MHz");
    public static final UniqueValueDef THERMAL_NOISE = Factory.results().single("Thermal noise", "dBm");
    public static final UniqueValueDef THERMAL_NOISE_UE = Factory.results().single("Thermal noise UE", "dBm");
    public static final UniqueValueDef COUPLING_LOSS_PERCENTILE = Factory.results().single("Coupling loss percentile", "");
    public static final UniqueValueDef SUB_CARRIER_RATIO = Factory.results().single("Sub carrier ratio", "Ratio");
    public static final VectorDef initialVictimOutage = Factory.results().value("Non Interfered Bitrate, ref cell", Unit.kbps.name());
    public static final VectorDef interferedBitRateRefCell = Factory.results().value("Interfered Bitrate, ref. cell", "kbps");
    public static final VectorDef SINRSystem = Factory.results().value("SINR, Victim system", "dB");
    public static final VectorDef SINRRefCell = Factory.results().value("SINR, Victim ref. cell", "dB");
    public static final VectorDef AVGAchievedBitRateSystem = Factory.results().value("Avg Non Interfered Bitrate, system", "kbps");
    public static final VectorDef avgInterferedBitRateSystem = Factory.results().value("Avg Interfered Bitrate, system", "kbps");
    private RadioSystem victim;
    private RadioSystem interferer;
    private SystemModelOFDMAUpLink ui;
    private PathLossCorrelation plCorr;
    private double mcl;
    private HybridSystemPlugin.SectorSetup sector;
    private boolean wrap;
    private double cellRadius;
    private HybridSystemPlugin.SystemLayout layout;
    private Function bitRateMapping;
    private double rbBandwidth;
    private double bandwidth;
    private double rnFigure;
    private double hoMargin;
    private Distribution msGain;
    private Distribution msHeight;
    private int maxMs;
    private int maxBs;
    private Distribution bsTilt;
    private int refSector;
    private int refCellId;
    private double interCellDistance;
    private AntennaGainConfiguration[] antennas;
    private PropagationModel propagationModel;

    @Override
    public String title() {
        return "Total sum per BS in reference cell";
    }

    @Override
    public String information() {
        return "Sum of contributions of all external interferer(s) perceived by the BS.";
    }

    @Override
    public String unwantedName() {
        return "iRSS Unwanted (external Interference)";
    }

    @Override
    public String blockingName() {
        return "iRSS Blocking (external Interference)";
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        if (context.getOrigin() == Origin.SYSTEM) {
            ConsistencyCheck.checkVictim(scenario, this, this.victim, validator);
        } else if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            ConsistencyCheck.checkInterferer(this, this.interferer, validator);
        }
    }

    @Override
    public Bounds getSystemCoverage() {
        double min = 0.0;
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        if (this.isUsingWrapAround()) {
            networkRadius *= 2.0;
        }
        VectorSpace network = VectorSpace.ZERO.addCircle(new Bounds(0.0, networkRadius, true));
        double max = network.getCoverage().getMax();
        return new Bounds(min, max, true);
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        VectorSpace range = VectorSpace.ZERO;
        return range.addCircle(new Bounds(0.0, networkRadius, true));
    }

    @Override
    public void setUI(SystemModelOFDMAUpLink ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelOFDMAUpLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        OFDMAUpLinkGeneralSettings gen = this.ui.generalSettings().generalSettings();
        this.mcl = gen.minimumCouplingLoss();
        this.sector = this.ui.positioning().position().sectorType();
        this.antennas = CellularCalculations.createSectorAntennas(this.sector, (AntennaGainConfiguration)this.ui.positioning().baseStation().antennaGain());
        this.cellRadius = this.ui.positioning().position().cellRadius();
        this.interCellDistance = 0.0;
        this.interCellDistance = this.sector != HybridSystemPlugin.SectorSetup.TriSector3GPP ? this.cellRadius * Mathematics.SQRT3 : this.cellRadius * 3.0;
        PathLossCorrelationUI plUI = this.ui.generalSettings().pathLossCorrelation();
        this.plCorr = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        this.wrap = this.ui.positioning().position().generateWrapAround();
        this.layout = this.ui.positioning().position().layout();
        this.bitRateMapping = gen.bitRateMapping().getFunction();
        this.rbBandwidth = gen.bandwidthResourceBlock();
        this.bandwidth = gen.bandwidth();
        this.rnFigure = gen.receiverNoiseFigure();
        this.hoMargin = gen.handoverMargin();
        this.msGain = this.ui.positioning().mobile().antennaGain();
        this.msHeight = this.ui.positioning().mobile().antennaHeight();
        this.maxMs = gen.maxSubcarriersMs();
        this.maxBs = gen.maxSubcarriersBs();
        this.bsTilt = this.ui.positioning().baseStation().antennaTilt();
        this.refSector = this.ui.positioning().position().referenceSector();
        this.refCellId = this.ui.positioning().position().referenceCellId();
        ReceiverSettings rx = this.ui.generalSettings().receiverSettings();
        double bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0;
        Receiver vReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), Factory.antennaGainFactory().getPeakGainAntenna(this.ui.positioning().mobile().antennaGain().trial()), this.ui.positioning().baseStation().antennaHeight());
        bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0;
        Receiver iReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), Factory.antennaGainFactory().getPeakGainAntenna(this.ui.positioning().mobile().antennaGain().trial()), this.ui.positioning().baseStation().antennaHeight());
        TransmitterSettings tx = this.ui.generalSettings().transmitterSettings();
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), 0.0, null, Factory.results().convert(this.ui.generalSettings().localEnvironments().transmitterEnvironments()), Factory.antennaGainFactory().getPeakGainAntenna(), this.ui.positioning().mobile().antennaHeight(), 0.0, false);
        this.propagationModel = this.ui.generalSettings().propagationModel();
        this.victim = new RadioSystem(vReceiver, transmitter, this.propagationModel);
        this.interferer = new RadioSystem(iReceiver, transmitter, this.propagationModel);
    }

    @Override
    public RadioSystem getSystem(Context context) {
        if (context.isVictim()) {
            return this.victim;
        }
        return this.interferer;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        UniformDistribution freq;
        double bw;
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(SIMULATION_FREQUENCY, frequency));
        double noise = CellularCalculations.calculateThermalNoise(this.getSystemBandwidth(), this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE, noise));
        noise = CellularCalculations.calculateThermalNoise((double)this.getMaxRBsPrMS() * this.getBandwidthOfAnRB() * 0.001, this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE_UE, noise));
        double ratio = (double)this.getMaxRBsPrMS() / (double)this.getMaxRBsPrBS();
        results.getSingleValueTypes().add(new DoubleResultType(SUB_CARRIER_RATIO, ratio));
        if (context.isVictim()) {
            bw = (double)this.getMaxRBsPrBS() * this.getBandwidthOfAnRB() / 1000.0;
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        } else {
            bw = this.interferer.getReceiver().getBandwidth();
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        }
        context.getSystemPlugin().setFrequency(freq);
        double clp = this.getPercentile().isRelevant() ? this.getPercentile().getValue() : CouplingLossEstimator.estimate(this, this.getSystem(context), frequency);
        results.getSingleValueTypes().add(new DoubleResultType(COUPLING_LOSS_PERCENTILE, clp));
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            double refCell = OFDMAUpLinkSystemPlugin.averagePercentage(results.findVector(initialVictimOutage), results.findVector(interferedBitRateRefCell));
            results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (ref. cell)", "%"), refCell));
            double system = OFDMAUpLinkSystemPlugin.averagePercentage(results.findVector(AVGAchievedBitRateSystem), results.findVector(avgInterferedBitRateSystem));
            results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (system)", "%"), system));
        }
    }

    public static double averagePercentage(VectorResultType v1, VectorResultType v2) {
        return OFDMAUpLinkSystemPlugin.averagePercentage(v1.getValue().asArray(), v2.getValue().asArray());
    }

    private static double averagePercentage(double[] v1, double[] v2) {
        double temp = 0.0;
        int count = 0;
        for (int i = 0; i < v1.length; ++i) {
            double initialValue = v1[i];
            double interferedValue = v2[i];
            if (initialValue == 0.0) continue;
            temp += 1.0 - interferedValue / initialValue;
            ++count;
        }
        if (count > 0) {
            temp = 100.0 * (temp / (double)count);
            return Mathematics.round(temp);
        }
        return 0.0;
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces systemSpaces) {
        if (context.isVictim()) {
            return new OFDMAUpLinkSimulation(this, this.victim);
        }
        return new OFDMAUpLinkSimulation(this, this.interferer);
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String correlationPoint) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof VictimImpl) || !((VictimImpl)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().rxAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Collections.singletonList("Victim BS ref.cell");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(NoneMode.MODE);
        modes.add(Correlated.MODE);
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return false;
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Collections.singletonList("Interfering BS ref.cell");
    }

    @Override
    public List<AsVictimInterferingLinkDefinition> definitions() {
        ArrayList<AsVictimInterferingLinkDefinition> list = new ArrayList<AsVictimInterferingLinkDefinition>();
        list.add(new AsVictimInterferingLinkDefinition(){

            @Override
            public String getName() {
                return "Path loss correlation";
            }

            @Override
            public String getInformation() {
                return "org.seamcat.model.generic.PathLossCorrelationUI.info";
            }

            @Override
            public Class getUIClass() {
                return PathLossCorrelationUI.class;
            }
        });
        return list;
    }

    public double getMinimumCouplingLoss() {
        return this.mcl;
    }

    public HybridSystemPlugin.SectorSetup getSectorSetup() {
        return this.sector;
    }

    public HybridSystemPlugin.TierSetup getTierSetup() {
        switch (this.ui.positioning().position().tiers()) {
            case 0: {
                return HybridSystemPlugin.TierSetup.SingleCell;
            }
            case 1: {
                return HybridSystemPlugin.TierSetup.OneTier;
            }
        }
        return HybridSystemPlugin.TierSetup.TwoTiers;
    }

    public double getCellRadius() {
        return this.cellRadius;
    }

    public HybridSystemPlugin.SystemLayout getSystemLayout() {
        return this.layout;
    }

    public int getIndexOfReferenceCell() {
        return this.refCellId;
    }

    public int getReferenceSector() {
        return this.refSector;
    }

    public double getInterCellDistance() {
        return this.interCellDistance;
    }

    public boolean isUsingWrapAround() {
        return this.wrap;
    }

    public AntennaGain[] getAntennas() {
        return this.antennas;
    }

    public Distribution getBaseStationTilt() {
        return this.bsTilt;
    }

    public int getMaxRBsPrBS() {
        return this.maxBs;
    }

    public int getMaxRBsPrMS() {
        return this.maxMs;
    }

    public int getNumberOfResourceBlocksPrBS() {
        if (this.useNumberOfActiveMsPerBs()) {
            return this.getNumberOfActiveMsPerBs();
        }
        return (int)Math.floor((double)this.getMaxRBsPrBS() / (double)this.getMaxRBsPrMS());
    }

    public Distribution getMobileStationHeight() {
        return this.msHeight;
    }

    public Distribution getMobileStationGain() {
        return this.msGain;
    }

    public PathLossCorrelation getPathLossCorrelation() {
        return this.plCorr;
    }

    public double getHandoverMargin() {
        return this.hoMargin;
    }

    public double getReceiverNoiseFigure() {
        return this.rnFigure;
    }

    public double getSystemBandwidth() {
        return this.bandwidth;
    }

    public double getBandwidthOfAnRB() {
        return this.rbBandwidth;
    }

    public Function getBitRateMapping() {
        return this.bitRateMapping;
    }

    public boolean useNumberOfActiveMsPerBs() {
        return this.ui.generalSettings().ueDistribution().numberOfActiveMsPerBs().isRelevant();
    }

    public int getNumberOfActiveMsPerBs() {
        return this.ui.generalSettings().ueDistribution().numberOfActiveMsPerBs().getValue();
    }

    public List<Double> getProbabilities() {
        return this.ui.generalSettings().ueDistribution().probabilities();
    }

    public double calculateFrequency(int resourceBlockNumber, double systemFrequency) {
        double systemBandwidth = this.getSystemBandwidth();
        double resourceBlockBandwidth = this.getBandwidthOfAnRB() * 0.001;
        double diff = systemBandwidth - (double)this.getMaxRBsPrBS() * resourceBlockBandwidth;
        return systemFrequency - systemBandwidth / 2.0 + diff / 2.0 + (double)this.getMaxRBsPrMS() * resourceBlockBandwidth / 2.0 * (double)(resourceBlockNumber * 2 + 1);
    }

    public double getMinimumTransmitPowerOfMS() {
        return this.ui.generalSettings().ofdmaUpLink().getMinimumTransmitPowerOfMS();
    }

    public double getMaximumAllowedTransmitPowerOfMS() {
        return this.ui.generalSettings().ofdmaUpLink().getMaximumAllowedTransmitPowerOfMS();
    }

    public double getBalancingFactor() {
        return this.ui.generalSettings().ofdmaUpLink().getBalancingFactor();
    }

    public OptionalValue<Double> getPercentile() {
        return this.ui.generalSettings().ofdmaUpLink().percentile();
    }

    public double getBandwidthOfResourceBlock() {
        return this.rbBandwidth;
    }

    public double getPowerScalingThreshold() {
        return this.ui.generalSettings().ofdmaUpLink().getPowerScalingThreshold();
    }

    public PropagationModel getPropagationModel() {
        return this.propagationModel;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(true, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

