/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmadownlink.simulation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmadownlink.simulation.BaseStation;
import org.seamcat.model.systems.ofdmadownlink.simulation.InterfererImpl;
import org.seamcat.model.systems.ofdmadownlink.simulation.Link;
import org.seamcat.model.systems.ofdmadownlink.simulation.MobileStation;
import org.seamcat.model.systems.ofdmadownlink.simulation.VictimImpl;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class SimulationImpl
implements SimulationInstance {
    private Distribution userAngle = Factory.distributionFactory().getUniformPolarAngleDistribution(360.0);
    private Distribution userLocation = Factory.distributionFactory().getUniformPolarDistanceDistribution(1.0);
    private OFDMADownLinkSystemPlugin system;
    private BaseStation[][] cells;
    private int numberOfBs;

    public SimulationImpl(OFDMADownLinkSystemPlugin system) {
        this.system = system;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        List<Link> activeConnections = this.initSystem(Point2D.ORIGIN, frequency);
        double sumRefCell = 0.0;
        double sum = 0.0;
        for (Link active : activeConnections) {
            VictimImpl victimImpl = new VictimImpl(collector.getPreSimulationResults(), active, Factory.antennaGainFactory().getPeakGainAntenna(active.getUserTerminal().getAntennaGain()), active.getLinkResult());
            collector.add(victimImpl);
            victimImpl.calculateAchievedBitrate();
            sum += victimImpl.getAchievedBitrate();
            if (!victimImpl.isConnectedToReferenceCell()) continue;
            sumRefCell += victimImpl.getAchievedBitrate();
        }
        collector.add(OFDMADownLinkSystemPlugin.AVGAchievedBitRateSystem, sum / (double)this.numberOfBS());
        collector.add(OFDMADownLinkSystemPlugin.AchievedBitRateRefCell, sumRefCell);
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        for (Victim victim : collector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            this.handle(vectors, v);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
    }

    private void handle(Map<VectorDef, List<Double>> vectors, VictimImpl victim) {
        if (victim.isConnectedToReferenceCell()) {
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY, victim.getUEFrequency());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED, victim.getAchievedBitrate());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER, victim.getReceivePower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED, victim.getSinr());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS, victim.getLinkResult().getTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS, victim.getLinkResult().getEffectiveTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER, victim.getInterferencePower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER, victim.getCurrentTransmitPower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE, victim.getInterSystemInterference());
        } else {
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL, victim.getUEFrequency());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL, victim.getAchievedBitrate());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL, victim.getReceivePower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL, victim.getSinr());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL, victim.getLinkResult().getTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL, victim.getLinkResult().getEffectiveTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER_ALL, victim.getInterferencePower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL, victim.getCurrentTransmitPower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE_ALL, victim.getInterSystemInterference());
        }
    }

    private void append(Map<VectorDef, List<Double>> vectors, VectorDef def, double value) {
        List<Double> values = vectors.get(def);
        if (values == null) {
            values = new ArrayList<Double>();
            vectors.put(def, values);
        }
        values.add(value);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        Results pre = eventResult.getInterferingSystemResult(link).getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        this.generateBaseStations(position, frequency);
        double txPower = Mathematics.fromWatt2dBm(Mathematics.fromdBm2Watt(this.system.getBSMaxTransmitPower()) * (double)this.system.getMaxRBsPrBS() / (double)this.system.getMaxRBsPrBS());
        for (BaseStation[] cell : this.cells) {
            for (int i = 0; i < this.cells[0].length; ++i) {
                BaseStation bs = cell[i];
                bs.setSubCarriersInUse(this.system.getMaxRBsPrBS());
                InterfererImpl interferer = new InterfererImpl(link.linkIndex(), bs, Factory.results().linkResult(), link.getCorrelationSettings().getMinimumCouplingLoss().trial());
                bs.setAntennaProperties(interferer.getLinkResult().txAntenna());
                interferer.getLinkResult().setTxPower(txPower);
                interferer.getLinkResult().setFrequency(frequency);
                eventResult.getInterferingSystemResult(link).add(interferer);
            }
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        VictimResultCollector collector = eventResult.getVictimResult();
        int size = collector.getVictims().size();
        double bitrateSum = 0.0;
        double bitRateSumRefCell = 0.0;
        double sinrSum = 0.0;
        double sinrSumRefCell = 0.0;
        int countRefCell = 0;
        for (Victim victim : collector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            v.calculateAchievedBitrate();
            bitrateSum += v.getAchievedBitrate();
            double sinr = Mathematics.dB2Linear(v.getSinr());
            sinrSum += sinr;
            if (!v.isConnectedToReferenceCell()) continue;
            sinrSumRefCell += sinr;
            bitRateSumRefCell += v.getAchievedBitrate();
            ++countRefCell;
        }
        collector.add(OFDMADownLinkSystemPlugin.AVGInterferedBitRateSystem, bitrateSum / (double)this.numberOfBS());
        collector.add(OFDMADownLinkSystemPlugin.InterferedBitRateRefCell, bitRateSumRefCell);
        double avg = size == 0 ? 0.0 : sinrSum / (double)size;
        double avgRefCell = countRefCell == 0 ? 0.0 : sinrSumRefCell / (double)countRefCell;
        collector.add(OFDMADownLinkSystemPlugin.SINR_SYSTEM, Mathematics.linear2dB(avg));
        collector.add(OFDMADownLinkSystemPlugin.SINR_REFCELL, Mathematics.linear2dB(avgRefCell));
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            if (!v.isConnectedToReferenceCell()) continue;
            victims.add(v);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
        VictimResultCollector vCollector = eventResult.getVictimResult();
        List<Victim> victims = this.getResultingVictims(vCollector);
        if (!victims.isEmpty()) {
            for (VectorDef def : vCollector.getVectorDefinitions()) {
                if (!def.name().startsWith("iRSS Unwanted") && !def.name().startsWith("iRSS Blocking")) continue;
                vCollector.add(def, Mathematics.linear2dB(Mathematics.dB2Linear(vCollector.get(def)) / (double)victims.size()));
            }
        }
    }

    private List<Link> initSystem(Point2D position, double frequency) {
        this.generateBaseStations(position, frequency);
        return this.positionMSsAndInitialConnectBS(position, frequency);
    }

    private void generateBaseStations(Point2D systemCenter, double frequency) {
        int cellsPrSite = this.system.getSectorSetup().getSectors();
        this.cells = new BaseStation[this.system.getTierSetup().getCellSites()][cellsPrSite];
        this.numberOfBs = this.system.getTierSetup().getCellSites() * cellsPrSite;
        double d = this.system.getInterCellDistance();
        for (int j = 0; j < this.cells.length; ++j) {
            for (int i = 0; i < this.cells[0].length; ++i) {
                Point2D position = this.system.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP ? GridPositionCalculator.ppg2(j, systemCenter, d) : GridPositionCalculator.standard(j, systemCenter, d);
                int cellId = i + cellsPrSite * j;
                boolean isReferenceCell = j == this.system.getIndexOfReferenceCell() && i == this.system.getReferenceSector();
                this.cells[j][i] = new BaseStation(frequency, position, this.system, cellId, this.system.getSystem(null).getTransmitter().getHeight().trial(), this.system.getBaseStationTilt().trial(), i, isReferenceCell);
            }
        }
    }

    private int numberOfBS() {
        return this.numberOfBs;
    }

    private List<Link> positionMSsAndInitialConnectBS(Point2D systemPosition, double frequency) {
        ArrayList<Link> activeLinks = new ArrayList<Link>();
        int K = this.system.getMaxRBsPrBS() / this.system.getMaxRBsPrMS();
        for (int v = 0; v < 10 * K; ++v) {
            this.generateMobileStations(v, systemPosition, frequency);
            boolean systemIsLoaded = true;
            for (BaseStation[] cell : this.cells) {
                for (int i = 0; i < this.cells[0].length; ++i) {
                    BaseStation bs = cell[i];
                    boolean bsLoaded = bs.initialConnect(activeLinks);
                    systemIsLoaded = systemIsLoaded && bsLoaded;
                }
            }
            if (!systemIsLoaded) continue;
            return activeLinks;
        }
        return activeLinks;
    }

    private void generateMobileStations(int count, Point2D systemPosition, double frequency) {
        int bsCount = this.numberOfBS();
        int K = this.system.getMaxRBsPrBS() / this.system.getMaxRBsPrMS();
        int offset = K * bsCount * count;
        int stop = K * bsCount;
        for (int i = 0; i < stop; ++i) {
            MobileStation ue = new MobileStation(frequency, this.system, i + offset, this.system.getMobileStationGain().trial(), this.system.getMobileStationHeight().trial());
            this.positionUser(ue, systemPosition);
            ue.linkToBSAndAddToCandidateList(this.cells);
        }
    }

    private void positionUser(MobileStation user, Point2D systemPosition) {
        double userAng = this.userAngle.trial();
        boolean singleHexagon = this.system.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP;
        double tierOffset = singleHexagon ? 0.5 : 1.0;
        double userDist = ((double)this.system.getTierSetup().getTiers() + tierOffset) * this.system.getInterCellDistance() * this.userLocation.trial();
        double x = userDist * Mathematics.cosD(userAng);
        double y = userDist * Mathematics.sinD(userAng);
        user.setPosition(systemPosition.add(x, y));
        for (BaseStation[] cell : this.cells) {
            Point2D position = user.getPosition();
            if (!(singleHexagon ? cell[0].inside(position) : cell[0].inside(position) || cell[1].inside(position) || cell[2].inside(position))) continue;
            return;
        }
        this.positionUser(user, systemPosition);
    }
}

