/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdma;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.systems.ofdma.FrequencySchedulingDialog;
import org.seamcat.model.systems.ofdma.OFDMAUEDistribution;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralSettings;
import org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.item.OptionalIntItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;

public class OFDMAUEDistributionBuilder
implements CustomPanelBuilder<OFDMAUEDistribution, SystemModelOFDMAUpLink> {
    @Override
    public PanelModelEditor<OFDMAUEDistribution> build(OFDMAUEDistribution model, final ModelEditor<SystemModelOFDMAUpLink> modelEditor) {
        final CalculatedValueItem item = new CalculatedValueItem().label("Frequency Scheduling");
        final OptionalIntItem activeMsPerBs = new OptionalIntItem(){

            @Override
            protected void updateWidgetRelevance(boolean enabled) {
                super.updateWidgetRelevance(enabled);
                item.setRelevant(enabled);
            }
        }.label("User defined active MS per BS");
        activeMsPerBs.information("Can be in the range of [1; Max. RBs per BS/Number of RBs per MS]");
        final GenericPanel panel = new GenericPanel();
        panel.addItem(activeMsPerBs);
        panel.addItem(item);
        panel.initializeWidgets();
        activeMsPerBs.setValue(new ValueWithUsageFlag<Integer>(false, model.numberOfActiveMsPerBs().getValue()));
        final OFDMAUEDistribution[] mod = new OFDMAUEDistribution[]{model};
        item.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Double> probabilities;
                SystemModelOFDMAUpLink ofdmaUpLink = (SystemModelOFDMAUpLink)modelEditor.getModel();
                OFDMAUpLinkGeneralSettings settings = ofdmaUpLink.generalSettings().generalSettings();
                int size = settings.maxSubcarriersBs() / settings.maxSubcarriersMs();
                FrequencySchedulingDialog dialog = size == (probabilities = mod[0].probabilities()).size() ? new FrequencySchedulingDialog(ofdmaUpLink.general().frequency(), settings, probabilities) : new FrequencySchedulingDialog(ofdmaUpLink.general().frequency(), settings, size);
                if (dialog.display()) {
                    OFDMAUEDistribution prototype = Factory.prototype(OFDMAUEDistribution.class, mod[0]);
                    Factory.when(prototype.probabilities()).thenReturn(dialog.getFrequencyProbabilities());
                    mod[0] = Factory.build(prototype);
                }
            }
        });
        return new PanelModelEditor<OFDMAUEDistribution>(){

            @Override
            public JPanel getPanel() {
                return panel;
            }

            @Override
            public OFDMAUEDistribution getModel() {
                OFDMAUEDistribution prototype = Factory.prototype(OFDMAUEDistribution.class, mod[0]);
                Object value = activeMsPerBs.getValue();
                Factory.when(prototype.numberOfActiveMsPerBs()).thenReturn(Factory.results().optional(((ValueWithUsageFlag)value).useValue, ((ValueWithUsageFlag)value).value));
                return Factory.build(prototype);
            }
        };
    }
}

